% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.pandemicPredicted.R
\name{print.pandemicPredicted}
\alias{print.pandemicPredicted}
\title{Prints prediction summary of pandemic model}
\usage{
\method{print}{pandemicPredicted}(x, summaryFun = stats::median, printPred = "Long", truncView = 3, ...)
}
\arguments{
\item{x}{An object of S3 class \code{\link{pandemicPredicted-objects}}.}

\item{summaryFun}{Use this function to summarize the predictions. Default argument is median, but can be any function on a vector.}

\item{printPred}{Valid values are 'Long' or 'Short'. Note that 'Short' will show short-term cumulative predictions, while
'Long' will return the long-term daily cases predicted.}

\item{truncView}{How many predictions to print. Default is 3, which means that the method prints the first
3 days predicted and the last 3 days of the prediction horizon.}

\item{...}{Currently unused.}
}
\description{
S3 method designed to summarize the prediction obtained by the
\code{\link{posterior_predict.pandemicEstimated}} function. It is not necessary to call function
directly, unless it is desired to change the default arguments.
}
\examples{
\dontrun{
dataMG = load_covid("Brazil","MG")
estimMG = pandemic_model(dataMG)
predMG = posterior_predict(estimMG)
print(predMG, summaryFun = mean, truncView = 5)}
}
\seealso{
\code{\link{posterior_predict.pandemicEstimated}} and \code{\link{plot.pandemicPredicted}}.
}
