% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawPlot_timeseries.R
\name{rawPlot_timeseries}
\alias{rawPlot_timeseries}
\title{Create Timeseries Plot from a Raw Dataframe}
\usage{
rawPlot_timeseries(
  df,
  parameter = "pm25",
  tlim = NULL,
  localTime = TRUE,
  shadedNight = TRUE,
  shadedBackground = NULL,
  sbLwd = 1,
  add = FALSE,
  gridPos = "",
  gridCol = "black",
  gridLwd = 1,
  gridLty = "solid",
  dayLwd = 0,
  hourLwd = 0,
  hourInterval = 6,
  ...
)
}
\arguments{
\item{df}{enhanced, raw dataframe as created by the raw_enhance() function}

\item{parameter}{raw parameter to plot}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{localTime}{logical specifying whether \code{tlim} is in local time or UTC}

\item{shadedNight}{add nighttime shading}

\item{shadedBackground}{add vertical lines for a second parameter}

\item{sbLwd}{shaded background line width}

\item{add}{logical specifying whether to add to the current plot}

\item{gridPos}{position of grid lines either \code{'over'}, \code{'under'} or \code{''} for no grid lines}

\item{gridCol}{grid line color}

\item{gridLwd}{grid line width}

\item{gridLty}{grid line type}

\item{dayLwd}{day marker line width}

\item{hourLwd}{hour marker line width}

\item{hourInterval}{interval for grid (max=12)}

\item{...}{additional arguments to pass to lines() function}
}
\description{
Creates a plot of raw monitoring data as generated using raw_enhance().

Other options for \code{parameter} include
\code{"temperature", "humidity", "windSpeed", "windDir", "pressure"}
or any of the other raw
parameters (try \code{names(df)} to see list of options)
}
\details{
Note that for multiple deployments, \code{shadedNight} defaults to use the lat/lon for the first deployment, which in theory
could be somewhat unrepresentative, such as if deployments have a large range in latitude.
}
\note{
If more than one timezone is found, \code{localTime} is ignored and UTC is used.
}
\keyword{raw}
