% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tothanalysis.R
\name{tothanalysis}
\alias{tothanalysis}
\title{Toth Isotherm Analysis Non-Linear Form}
\usage{
tothanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the fractional coverage}
}
\value{
The non linear regression and the parameters for the Toth isotherm analysis
}
\description{
Another empirical modification of the Langmuir equation with the aim of reducing the error between experimental data and predicted value of equilibrium data.
}
\examples{
tothanalysis(c(1,2,3,4,5),c(1,2,3,4,5))
}
\references{
Gutierrez, L.G., et.al(2018, September 20), Kinetic and Equilibrium Study of the Absorption of CO2 in Ultramicropores of Resorcinol-Formaldehyde Aerogels obtained in Acidic and Basic Medium. Retrieved from: doi:10.3390/c4040052

Ayawei, N. (2017, September 05). Medelling an Interpretation of Adsorption Isotherm. Retrieved from: https://www.hidawi.com/journals/jchem/2017/3039817
}
\author{
Kim Zyrell P. Zagala

C.C. Deocaris
}
