% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_MQ.R
\name{boxplotCompare}
\alias{boxplotCompare}
\title{Boxplots - one for each condition (=column) in a data frame.}
\usage{
boxplotCompare(data, log2 = TRUE, ylab = "intensity", mainlab = ylab,
  sublab = "", boxes_per_page = 30, abline = NA, coord_flip = TRUE,
  names = NA)
}
\arguments{
\item{data}{Data frame in long format with numerical expression data}

\item{log2}{Apply log2 to the data (yes/no)}

\item{ylab}{Label on Y-axis}

\item{mainlab}{Main title}

\item{sublab}{Sub title}

\item{boxes_per_page}{Maximum number of boxplots per plot. Yields multiple plots if more groups are given.}

\item{abline}{Draw a horizontal green line at the specified y-position (e.g. to indicate target median values)}

\item{coord_flip}{Exchange Y and X-axis for better readability}

\item{names}{An optional data.frame(long=.., short=..), giving a renaming scheme (long->short) for the 'name' column}
}
\value{
List of ggplot objects
}
\description{
Given a data.frame with two/three columns in long format (name, value, [contaminant]; in that order), each group (given from 1st column)
is plotted as a bar.
Contaminants (if given) are separated and plotted as yellow bars.
}
\details{
Boxes are shaded: many NA or Inf lead to more transparency. Allows to easily spot sparse groups
}
