% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{supCount}
\alias{supCount}
\title{Compute shortest prefix length which makes all strings in a vector uniquely identifyable.}
\usage{
supCount(x, prefix_l = 1)
}
\arguments{
\item{x}{Vector of strings}

\item{prefix_l}{Starting prefix length, which is incremented in steps of 1 until all prefixes are unique (or maximum string length is reached)}
}
\value{
Integer with minimal prefix length required
}
\description{
If there is no unique prefix (e.g. if a string is contained twice), then the length
of the longest string is returned, i.e. if the return value is used in a call to substr, nothing happens
e.g.  substr(x, 1, supCount(x)) == x
}
\examples{
  supCount(c("abcde...", "abcd...", "abc..."))  ## 5

  x = c("doubled", "doubled", "aLongDummyString")
  all( substr(x, 1, supCount(x)) == x )   
  ## TRUE (no unique prefix due to duplicated entries)

}

