\name{generateSampleDataFile}
\alias{generateSampleDataFile}
\title{Generate sample data files for profile regression}
\description{Generation of random sample datasets for profile regression.}
\usage{
generateSampleDataFile(clusterSummary)
}
\arguments{
\item{clusterSummary}{A vector of strings of the covariate names as by the column names in the data argument.}
}
\value{
The output of this function is a list with the following elements
\item{yModel}{The outcome model according to which the data has been generated.}
\item{xModel}{The covariate model according to which the data has been generated.}
\item{inputData}{The data.frame that contains the data.}
\item{covNames}{The names of the covariates.}
\item{fixedEffectNames}{The names of the fixed effects.}

}
\section{Authors}{
David Hastie, Department of Epidemiology and Biostatistics, Imperial College London, UK

Silvia Liverani, Department of Epidemiology and Biostatistics, Imperial College London and MRC Biostatistics Unit, Cambridge, UK

Maintainer: Silvia Liverani <liveranis@gmail.com>
}
\references{

Liverani, S., Hastie, D. I., Papathomas, M. and Richardson, S. (2013) PReMiuM: An R package for Profile Regression Mixture Models using Dirichlet Processes. \emph{Submitted}. Avalable at http://uk.arxiv.org/abs/1303.2836

}
\examples{
# generation of data for clustering

generateDataList <- clusSummaryBernoulliDiscrete()
inputs <- generateSampleDataFile(generateDataList)

}
\keyword{simulation}

