\name{hp_plot}
\alias{hp_plot}
\title{Visualise a Hyperplane Separator for Clustering}
\description{
  Provides a visualisation of the partition induced by a hyperplane separator generated by one of mch, mdh and ncuth.
}
\usage{
hp_plot(sol, X, labels)
}
\arguments{
  \item{sol}{a solution arising from one of the functions mch, mdh and ncuth.}
  \item{X}{the sme data matrix used to produce sol.}
  \item{labels}{(optional) a vector of class labels. if provided then points in different classes are plotted in different colours. the external validity of the partition is also indicated when this can be computed using true class labels.}
}
\examples{
## load optidigits dataset
data(optidigits)

## find a minimum normalised cut hyperplane for this dataset
sol <- ncuth(optidigits$x)

## visualise the induced partition
hp_plot(sol, optidigits$x)
}
\keyword{file}
