% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likPOUMM.R
\name{rVNodesGivenTreePOUMM}
\alias{rVNodesGivenTreePOUMM}
\title{Random generation of values along a phylogenetic tree following a branching
OU process}
\usage{
rVNodesGivenTreePOUMM(tree, z0, alpha, theta, sigma, sigmae = 0)
}
\arguments{
\item{tree}{An object of class phylo (package ape).}

\item{z0}{Numeric value indicating the initial state at the root of the tree.}

\item{alpha, theta, sigma}{Numeric values, parameters of the OU process.}

\item{sigmae}{Numeric non-negative value (default 0). Specifies the standard
deviation of random environmental contribution and or measurement standard 
error to be added to the values (white noise). Note that if measurement standard
error, se, is known and needs to be added to the environmental contribution,
the right way to specify the parameter would be sqrt(sigmae^2+se^2).}
}
\value{
A numeric vector containing the generated values at all nodes
  (internal and tips) of the phylogenetic tree.
}
\description{
Random generation of values along a phylogenetic tree following a branching
OU process
}
\examples{
  
\dontrun{
  N <- 20 
  tree <- TreeSim::sim.bd.taxa(N, 1, lambda = 2, mu = 1, complete =
  FALSE)[[1]] 
  z <- rVNodesGivenTreePOUMM(tree, 8, 2, 2, 1)
  
  phytools::plotBranchbyTrait(tree, z, mode = "nodes", show.tip.label =
  FALSE, show.node.label = FALSE) 
  ape::nodelabels(round(z[-(1:N)], 2)) 
  ape::tiplabels(round(z[(1:N)], 2))
} 
}

