% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likPOUMM.R
\name{likPOUMM_C}
\alias{likPOUMMGivenTreeVTipsC}
\alias{likPOUMMGivenTreeVTipsC2}
\alias{likPOUMMGivenTreeVTipsC4}
\alias{likPOUMM_C}
\title{Fast POUMM likelihood calculation based on the breadth-first 
pruning algorithm.}
\usage{
likPOUMMGivenTreeVTipsC(integrator, alpha, theta, sigma, sigmae, g0 = NA,
  g0Prior = NULL, log = TRUE)

likPOUMMGivenTreeVTipsC2(integrator, alpha, theta, sigma, sigmae, g0 = NA,
  g0Prior = NULL, log = TRUE)

likPOUMMGivenTreeVTipsC4(integrator, alpha, theta, sigma, sigmae, g0 = NA,
  g0Prior = NULL, log = TRUE)
}
\arguments{
\item{integrator}{An object of the Integrator C++ class (see example).
trait values at the tip-nodes.}

\item{alpha}{the strength of the selection}

\item{theta}{long term mean value of the OU process}

\item{sigma}{the unit-time standard deviation of the random component in the
OU process.}

\item{sigmae}{the standard deviation of the environmental deviation added to
the genetic contribution at each tip, by default 0, meaning no
environmental deviation.}

\item{g0}{Numeric, NA or NaN, either a fixed genotypic value at the root of 
tree or NA or NaN. A NA "Not Available" will cause to analytically
calculate the value of g0 that would maximize the conditional likelihood of
the data given g0. A NaN "Not a Number" will cause integration over g0
taking values in (-Inf,+Inf) assuming that g0 is normally distributed with
mean g0Prior$mean and variance g0Prior$var (see parameter g0Prior).}

\item{g0Prior}{Either NULL or a list with named numeric or character members
"mean" and "var". Specifies a prior normal distribution for the parameter g0.
If characters, the members mean and var are evaluated as R-expressions.}

\item{log}{Logical indicating whether log-likelihood should be returned
instead of likelihood, default is TRUE.}
}
\value{
A numeric with attributes "g0" and "g0LogPrior".
}
\description{
The function likPOUMMGivenTreeVTipsC is using elementwise 
  vector operations from the Armadillo library. The function
  likPOUMMGivenTreeVTipsC2 is using C++ for loops which benefit from
  better vectorization of native algebraic expressions. The function 
  likPOUMMGivenTreeVTipsC3 adds to likPOUMMGivenTreeVTipsC2 Open MP 
  parallelization (mostly available on multi-core Linux systems).
}
\details{
This function is the C++ equivalent of dVTipsGivenTreePOUMM (aliased also as
likPOUMMGivenTreeVTips). C++ implementation using contiguous vector operations and
 vectors a, b and c
}
\section{Functions}{
\itemize{
\item \code{likPOUMMGivenTreeVTipsC}: using RcppArmadillo and simd vectorization

\item \code{likPOUMMGivenTreeVTipsC2}: Using omp simd operations in C++ for-loops

\item \code{likPOUMMGivenTreeVTipsC4}: Using OpenMP and SIMD parallelization if available on 
the system. This implementation differs from likPOUMMGivenTreeVTipsC3 by
the use of longer code-blocks in for-loops (better adapted for the Intel C++
compiler).
}}
\examples{
\dontrun{
N <- 100
tr <- ape::rtree(N)
z <- POUMM::rVNodesGivenTreePOUMM(tr, 0, 2, 3, 1, 1)[1:N]
pruneInfo <- POUMM::pruneTree(tr, z)
microbenchmark::microbenchmark(
  likArma <- POUMM::likPOUMMGivenTreeVTipsC(pruneInfo$integrator, 2, 3, 1, 1),
  likR <- POUMM::likPOUMMGivenTreeVTips(z, tr, 2, 3, 1, 1, pruneInfo = pruneInfo))

# should be the same values
likArma
likR
}

}

