% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POUMM.R
\name{POUMM}
\alias{POUMM}
\title{The Phylogenetic (Ornstein-Uhlenbeck) Mixed Model}
\usage{
POUMM(z, tree, se = 0, zName = "z", treeName = "tree", parDigits = 6,
  usempfr = 0, useCpp = TRUE, ..., spec = NULL, doMCMC = TRUE,
  verbose = FALSE, debug = FALSE)
}
\arguments{
\item{z}{Either a numeric vector containing the phenotypic values at the tips 
of tree or a named list containing named elements z - a numeric vector and 
tree - a phylo object (it is possible to specify different element names 
using the arguments zName and treeName).}

\item{tree}{A phylo object or NULL in case z is a list.}

\item{se}{A non-negative numerical vector (or single number) indicating known 
measurement standard error (defaults to 0). Note the elements of this vector 
are assumed to describe the measurement error at individual nodes independent
of the environmental contribution (described by the parameter sigmae). The total
error standard deviation is thus sqrt(sigmae2+se^2).}

\item{zName, treeName}{Character strings used when the parameter z is a list; 
indicate the names in the list of the values-vector and the tree. Default: 
'z' and 'tree'.}

\item{parDigits}{Integer specifying rounding to be done on the parameter 
vector before likelihood calculation. Defaults to 6 decimal digits. This can
be useful during maximum likelihood optimization to prevent likelihood 
calculation on very small but positive values of alpha, but should be used 
with caution since specifying a small number of digits, i.e. 2 or 3 can
result in an infinite loop during optim. Specify a negative number
to disable rounding.}

\item{usempfr}{integer indicating if and how mpfr should be used for small 
parameter values (any(c(alpha, sigma, sigmae) < 0.01)). Using the mpfr 
package can be forced by specifying an integer greater or equal to 2. 
Setting usempfr=0 (default) causes high precision likelihood 
calculation to be done on each encounter of parameters with at least 1 bigger
log-likelihood value than any of the currently found
maximum log-likelihood or the previously calculated log-likelihood value
Requires the Rmpfr package. Note that using mpfr may increase the time for 
one likelihood calculation more than 100-fold. Set usempfr to -1 or less
to completely disable Rmpfr functionality.}

\item{useCpp}{Logical indicating whether C++ likelihood calculation should be 
used for faster vector operations. Defaults to TRUE. Since the C++ likelihood
implementation does not support mpfr, useCpp gets disabled when usempfr is 
bigger than 0.}

\item{...}{additional arguments passed to the likPOUMMGivenTreeVTips function 
(?dVGivenTreeOU for details).}

\item{spec}{A named list specifying how the ML and MCMC fit should be done. 
See ?specifyPOUMM.}

\item{doMCMC}{Deprecated - use nSamplesMCMC = 0 instead. 
logical: should a MCMC fit be performed. An MCMC fit provides a 
sample from the posterior distribution of the parameters given a prior 
distribution and the data. Unlike the ML-fit, it allows to estimate 
confidence intervals for the estimated parameters. This argument is TRUE by 
default. The current implementation uses a modified version of the adaptive 
Metropolis sampler from the package "adaptMCMC" written by Andreas 
Scheidegger. To obtain meaningful estimates MCMC may need to run for several
millions of iterations (parameter nSamplesMCMC set to 1e5 by default). See 
parameters ending at MCMC in ?specifyPOUMM for details.}

\item{verbose, debug}{Logical flags indicating whether to print informative 
and/or debug information on the standard output (both are set to to FALSE by
default).}
}
\value{
An object of S3 class 'POUMM'. This object can be analyzed using 
 S3 generic functions: \code{\link{summary}}, 
 \code{\link{plot}}, \code{\link{AIC}}, \code{\link{BIC}}, \code{\link{coef}},
 \code{\link{logLik}}, \code{\link{fitted}}.
}
\description{
This is the high-level entry point to the POUMM method. The POUMM
 function fits the POUMM method to a tree and observed trait-values at its tips
  and returns an object of class "POUMM".
}
\examples{
\dontrun{
# Please, read the package vignette for more detailed examples.
N <- 500
tr <- ape::rtree(N)
z <- POUMM::rVNodesGivenTreePOUMM(tr, 0, 2, 3, 1, 1)[1:N]
fit <- POUMM::POUMM(z, tr, spec = POUMM::specifyPOUMM(nSamplesMCMC = 5e4))
plot(fit)
summary(fit)
AIC(fit)
BIC(fit)
coef(fit)
logLik(fit)
fitted(fit)
plot(resid(fit))
abline(h=0)

# fit PMM to the same data and do a likelihood ratio test
fitPMM <- POUMM::POUMM(z, tr, spec = POUMM::specifyPMM(nSamplesMCMC = 5e4))
lmtest::lrtest(fitPMM, fit)
}

}
\references{
Mitov, V., and Stadler, T. (2017). Fast and Robust Inference of Phylogenetic Ornstein-Uhlenbeck Models Using Parallel Likelihood Calculation. bioRxiv, 115089. 
 https://doi.org/10.1101/115089
 
 Vihola, M. (2012). Robust adaptive Metropolis algorithm with coerced 
 acceptance rate. Statistics and Computing, 22(5), 997-1008. 
 http://doi.org/10.1007/s11222-011-9269-5 
 
 Scheidegger, A. (2012). adaptMCMC: Implementation of a generic adaptive 
 Monte Carlo Markov Chain sampler. 
 http://CRAN.R-project.org/package=adaptMCMC
}
\seealso{
\code{\link{specifyPOUMM}} for parametrizations and custom settings
 of the POUMM fit.
}

