.validity_PvMethod_Davies <- function(object) {

  if (length(x = object@args) == 0L) return( TRUE )

  daviesArgs <- names(x = formals(fun = davies))

  if (!all(names(x = object@args) %in% daviesArgs)) {
    return( "arguments provided do not match call to davies" )
  }

  return( TRUE )
}

# Class \code{PvMethod_Davies}
#
# Class \code{PvMethod_Davies} stores arguments for p-value method using davies
#
# @name PvMethod_Davies-class
# 
# @keywords internal
#
# @include B_PvMethod.R
#
setClass(Class = "PvMethod_Davies",
         contains = c("PvMethod"),
         prototype = list(args = list()),
         validity = .validity_PvMethod_Davies)

# @rdname calcPV
setMethod(f = ".calcPV",
          signature = c(method = "PvMethod_Davies"),
          definition = function(method, psi, ev, ...) {

            argList <- method@args
            argList[[ "q" ]] <- .Ts(psi = psi)
            argList[[ "lambda" ]] <- ev    

            res <- tryCatch(expr = do.call(what = davies,
                                           args = argList),
                            error = function(e){
                                print(x = e$message)
                                stop("error generated by CompQuadForm::davies", call. = FALSE)
                              })

            return( res$Qq )
          })
