% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pns.R
\name{get_pns}
\alias{get_pns}
\title{Download, label, deflate and create survey design object for PNS microdata}
\usage{
get_pns(
  year,
  selected = FALSE,
  anthropometry = FALSE,
  vars = NULL,
  labels = TRUE,
  deflator = TRUE,
  design = TRUE,
  savedir = tempdir()
)
}
\arguments{
\item{year}{The year of the data to be downloaded. Must be a number equal to 2013 or 2019 or 2024. Vector not accepted.}

\item{selected}{Logical value. If \code{TRUE}, the specific questionnaire for selected resident will be used. If \code{FALSE}, the basic questionnaire for household and residents will be used.}

\item{anthropometry}{Logical value. If \code{TRUE}, the specific questionnaire for the anthropometry module of the selected resident will be used. If \code{FALSE}, the questionnaire defined by the \code{selected} argument of this function will be used. This argument will be used only if \code{year} is equal to 2019 or 2024.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}

\item{labels}{Logical value. If \code{TRUE}, categorical variables will presented as factors with labels corresponding to the survey's dictionary.}

\item{deflator}{Logical value. If \code{TRUE}, deflator variables will be available for use in the microdata.}

\item{design}{Logical value. If \code{TRUE}, will return an object of class \code{survey.design} or \code{svyrep.design}. It is strongly recommended to keep this parameter as \code{TRUE} for further analysis. If \code{FALSE}, only the microdata will be returned.}

\item{savedir}{Directory to save the downloaded data. Default is to use a temporary directory.}
}
\value{
An object of class \code{survey.design} or \code{svyrep.design} with the data from PNS and its sample design, or a tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
Core function of package. With this function only, the user can download a PNS microdata from a year and get a sample design object ready to use with \code{survey} package functions.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
\donttest{
pns.svy <- get_pns(year=2019, selected=FALSE, anthropometry=FALSE, vars=c("J007","J009"),
                       labels=TRUE, deflator=TRUE, design=TRUE, savedir=tempdir())
# Calculating proportion of people diagnosed with chronic diseases
if (!is.null(pns.svy)) survey::svymean(x=~J007, design=pns.svy, na.rm=TRUE)
pns.svy2 <- get_pns(year=2019, selected=TRUE, anthropometry=FALSE, vars=c("N001","N00101"),
                       labels=TRUE, deflator=TRUE, design=TRUE, savedir=tempdir())
# Calculating proportion of people's self-rated health
if (!is.null(pns.svy2)) survey::svymean(x=~N001, design=pns.svy2, na.rm=TRUE)
pns.svy3 <- get_pns(year=2019, selected=FALSE, anthropometry=TRUE, vars=c("W00101","W00201"),
                       labels=TRUE, deflator=TRUE, design=TRUE, savedir=tempdir())
# Calculating the average weight of people
if (!is.null(pns.svy3)) survey::svymean(x=~W00101, design=pns.svy3, na.rm=TRUE)}
}
\seealso{
\link[PNSIBGE]{read_pns} for reading PNS microdata.\cr \link[PNSIBGE]{pns_labeller} for labeling categorical variables from PNS microdata.\cr \link[PNSIBGE]{pns_deflator} for adding deflator variables to PNS microdata.\cr \link[PNSIBGE]{pns_design} for creating PNS survey design object.\cr \link[PNSIBGE]{pns_example} for getting the path of the PNS toy example files.
}
