% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pns.R
\name{read_pns}
\alias{read_pns}
\title{Read PNS microdata}
\usage{
read_pns(microdata, input_txt, vars = NULL)
}
\arguments{
\item{microdata}{A text file containing microdata from PNS survey, available on official website: (select a microdata file, according to the appropriated year, microdata folder and then, inside, data) - \url{https://ftp.ibge.gov.br/PNS/}.}

\item{input_txt}{A text file, related to the microdata, containing the input script for SAS, available on official website: (select the dictionary and input zip file, according to the appropriated year, microdata folder and then, inside, documentation) - \url{https://ftp.ibge.gov.br/PNS/}.}

\item{vars}{Vector of variable names to be kept for analysis. Default is to keep all variables.}
}
\value{
A tibble with selected variables of the microdata, including the necessary survey design ones.
}
\description{
This function reads PNS microdata.
}
\note{
For more information, visit the survey official website <\url{https://www.ibge.gov.br/estatisticas/sociais/saude/9160-pesquisa-nacional-de-saude.html?=&t=o-que-e}> and consult the other functions of this package, described below.
}
\examples{
input_path <- pns_example(path="input_example.txt")
data_path <- pns_example(path="exampledata.txt")
pns.df <- read_pns(microdata=data_path, input_txt=input_path, vars="J007")
}
\seealso{
\link[PNSIBGE]{get_pns} for downloading, labelling, deflating and creating survey design object for PNS microdata.\cr \link[PNSIBGE]{pns_labeller} for labelling categorical variables from PNS microdata.\cr \link[PNSIBGE]{pns_deflator} for adding deflator variable to PNS microdata.\cr \link[PNSIBGE]{pns_design} for creating PNS survey design object.\cr \link[PNSIBGE]{pns_example} for getting the path of the PNS example files.
}
