% Generated by roxygen2 (4.0.1): do not edit by hand
\name{PLS.biplot_no.SN}
\alias{PLS.biplot_no.SN}
\title{The Partial Least Squares (PLS) biplot with no sample points names}
\usage{
PLS.biplot_no.SN(X, Y, algorithm = NULL, ax.tickvec.X = NULL,
  ax.tickvec.Y = NULL, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{Y}{A (NxM) response matrix}

\item{algorithm}{Any of the PLS algorithms ("mod.NIPALS", "mod.KernelPLS_R", "mod.KernelPLS_L", "mod.SIMPLS")}

\item{ax.tickvec.X}{tick marker length for each X-variable axis in the PLS biplot}

\item{ax.tickvec.Y}{tick marker length for each Y-variable axis in the PLS biplot}

\item{...}{Other arguments. Currently ignored}
}
\value{
The PLS biplot of D=[X Y] with no sample points names
}
\description{
Takes in a set of predictor variables and a set of response variables and produces a PLS biplot, but with no sample points names.
}
\examples{
if(require(pls))
data(oliveoil, package="pls")
X = as.matrix(oliveoil$chemical, ncol=5)
dimnames(X) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4","I5",
"S1","S2","S3","S4","S5","S6")),
paste(c("Acidity","Peroxide","K232","K270","DK")))
Y = as.matrix(oliveoil$sensory, ncol=6)
dimnames(Y) = list(paste(c("G1","G2","G3","G4","G5","I1","I2","I3","I4","I5",
"S1","S2","S3","S4","S5","S6")),
paste(c("Yellow","Green","Brown","Glossy","Transp","Syrup")))
PLS.biplot_no.SN(X, Y, algorithm=mod.SIMPLS, ax.tickvec.X=c(8,5,5,5,5),
 ax.tickvec.Y=c(5,8,5,6,9,8))

#cocktail data
if(require(SensoMineR))
data(cocktail, package="SensoMineR")
X3 = as.matrix(compo.cocktail, ncol=4)
Y3 = as.matrix(senso.cocktail, ncol=13)
PLS.biplot_no.SN(X=X3, Y3, algorithm=mod.SIMPLS, ax.tickvec.X=rep(2,ncol(X3)),
 ax.tickvec.Y=rep(3,ncol(Y3)))
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

