% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixture.R
\name{PLNmixture}
\alias{PLNmixture}
\title{Poisson lognormal mixture model}
\usage{
PLNmixture(formula, data, subset, clusters = 1:5, control = PLNmixture_param())
}
\arguments{
\item{formula}{an object of class "formula": a symbolic description of the model to be fitted.}

\item{data}{an optional data frame, list or environment (or object coercible by as.data.frame to a data frame) containing the variables in the model. If not found in data, the variables are taken from environment(formula), typically the environment from which lm is called.}

\item{subset}{an optional vector specifying a subset of observations to be used in the fitting process.}

\item{clusters}{a vector of integer containing the successive number of clusters (or components) to be considered}

\item{control}{a list-like structure for controlling the optimization, with default generated by \code{\link[=PLNmixture_param]{PLNmixture_param()}}. See the associated documentation
for details.}
}
\value{
an R6 object with class \code{\link{PLNmixturefamily}}, which contains
a collection of models with class \code{\link{PLNmixturefit}}
}
\description{
Fit the mixture variants of the Poisson lognormal with a variational algorithm. Use the (g)lm syntax for model specification (covariates, offsets).
}
\examples{
## Use future to dispatch the computations on 2 workers
\dontrun{
future::plan("multisession", workers = 2)
}

data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myMixtures <- PLNmixture(Abundance ~ 1 + offset(log(Offset)), clusters = 1:4, data = trichoptera,
                         control = PLNmixture_param(smoothing = 'none'))

# Shut down parallel workers
\dontrun{
future::plan("sequential")
}
}
\seealso{
The classes \code{\link{PLNmixturefamily}}, \code{\link{PLNmixturefit}} and \code{\link[=PLNmixture_param]{PLNmixture_param()}}
}
