% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfamily-class.R
\docType{data}
\name{PLNPCAfamily}
\alias{PLNPCAfamily}
\title{An R6 Class to represent a collection of PLNPCAfit}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
PLNPCAfamily
}
\description{
The function \code{\link{PLNPCA}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel.PLNPCAfamily]{getBestModel}},
\code{\link[=getModel.PLNPCAfamily]{getModel}} and  \code{\link[=plot.PLNPCAfamily]{plot}}.
}
\section{Fields}{

\describe{
\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{ranks}}{the dimensions of the successively fitted models}

\item{\code{models}}{a list of \code{\link[=PLNPCAfit]{PLNPCAfit}} object, one per rank.}

\item{\code{inception}}{a \code{\link[=PLNfit]{PLNfit}} object, obtained when full rank is considered.}

\item{\code{criteria}}{a data frame with the values of some criteria (variational lower bound J, BIC, ICL and R2) for the different models.}
}}

\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCAs <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
class(myPCAs)
}
\seealso{
The function \code{\link{PLNPCA}}, the class \code{\link[=PLNPCAfit]{PLNPCAfit}}
}
\keyword{datasets}
