% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{selectPLMIX}
\alias{selectPLMIX}
\title{Bayesian selection criteria for mixtures of Plackett-Luce models}
\usage{
selectPLMIX(pi_inv, seq_G, MCMCsampleP = vector(mode = "list", length =
  length(seq_G)), MCMCsampleW = vector(mode = "list", length = length(seq_G)),
  MAPestP, MAPestW, log_lik = vector(mode = "list", length = length(seq_G)),
  deviance, post_summary = c("mean", "median"), parallel = FALSE)
}
\arguments{
\item{pi_inv}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial orderings.}

\item{seq_G}{Numeric vector with the number of components of the considered Plackett-Luce mixtures.}

\item{MCMCsampleP}{List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{L}\eqn{\times}{x}\eqn{(G*K)} matrix with the posterior MCMC samples of the component-specific support parameters.}

\item{MCMCsampleW}{List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{L}\eqn{\times}{x}\eqn{G} matrix with the posterior MCMC samples of the mixture weights.}

\item{MAPestP}{List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the MAP estimates of the component-specific support parameters.}

\item{MAPestW}{List of length \code{length(seq_G)}, whose generic element is a numeric vector of \eqn{G} MAP estimates of the mixture weights.}

\item{log_lik}{List of length \code{length(seq_G)}, whose generic element is a numeric vector of posterior log-likelihood values.}

\item{deviance}{List of length \code{length(seq_G)}, whose generic element is a numeric vector of posterior deviance values.}

\item{post_summary}{Character string indicating the summary statistic for computing the point estimates of the Plackett-Luce mixture parameters from the posterior MCMC sample. This argument is ignored when MAP estimates are supplied in the \code{MAPestP} and \code{MAPestW} arguments. Default is \code{"mean"}.}

\item{parallel}{Logical: whether parallelization should be used. Default is \code{FALSE}.}
}
\value{
A list of named objects:

 \item{\code{point_estP}}{ List of length \code{length(seq_G)}, whose generic element is a numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix with the point estimates of the component-specific support parameters.}
 \item{\code{point_estW}}{ List of length \code{length(seq_G)}, whose generic element is a numeric vector with the \eqn{G} point estimates of the mixture weights.}
 \item{\code{fitting_measures}}{ Numeric \code{length(seq_G)}\eqn{\times}{x}\eqn{2} matrix with the fitting measures given by the posterior expected deviance \code{D_bar} and the deviance \code{D_hat} evaluated at the point estimate.}
 \item{\code{effective_number _of_parameters}}{ Numeric \code{length(seq_G)}\eqn{\times}{x}\eqn{2} matrix of penalty terms \code{pD} and \code{pV}.}
 \item{\code{selection_criteria}}{ Numeric \code{length(seq_G)}\eqn{\times}{x}\eqn{6} matrix of Bayesian model selection criteria: \code{DIC1}, \code{DIC2}, \code{BPIC1}, \code{BPIC2}, \code{BICM1} and \code{BICM2}. See Details for further explanation.}
}
\description{
Compute Bayesian comparison criteria for mixtures of Plackett-Luce models with a different number of components.
}
\examples{
library(PLMIX)
data(d_carconf)
K <- ncol(d_carconf)
n.starting=2

GG <- 1
outputMAP_1 <- mapPLMIX_multistart(pi_inv=d_carconf, K=K, G=GG, 
                                   n_start=n.starting, n_iter=400*GG)

GG <- 2
outputMAP_2 <- mapPLMIX_multistart(pi_inv=d_carconf, K=K, G=GG, 
                                   n_start=n.starting, n_iter=400*GG)

mcmc_iterations=30
burnin=10

outputGIBBS_1 <- gibbsPLMIX(pi_inv=d_carconf, K=K, G=1, n_iter=mcmc_iterations, 
                           n_burn=burnin, init=list(p=outputMAP_1$mod$P_map,
                           z=binary_group_ind(outputMAP_1$mod$classification,G=1)))
outputGIBBS_2 <- gibbsPLMIX(pi_inv=d_carconf, K=K, G=2, n_iter=mcmc_iterations, 
                            n_burn=burnin, init=list(p=outputMAP_1$mod$P_map,
                            z=binary_group_ind(outputMAP_2$mod$classification,G=2)))

outputSELECT <- selectPLMIX(pi_inv=d_carconf, seq_G=1:2, 
                            MAPestP=list(outputMAP_1$mod$P_map, outputMAP_2$mod$P_map), 
                           MAPestW=list(outputMAP_1$mod$W_map, outputMAP_2$mod$W_map), 
                           deviance=list(outputGIBBS_1$deviance, outputGIBBS_2$deviance))
outputSELECT$selection_criteria
}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.

Ando, T. (2007). Bayesian predictive information criterion for the evaluation of hierarchical Bayesian and empirical Bayes models. \emph{Biometrika}, \bold{94}(2), pages 443--458.

Raftery, A. E, Satagopan, J. M., Newton M. A., Krivitsky, P. N. (2007). BAYESIAN STATISTICS 8. \emph{Proceedings of the eighth Valencia International Meeting 2006}, pages 371--416. Oxford University Press.

Gelman, A, Carlin, J. B., Stern, H. S., Rubin, D. B. (2004). Bayesian data analysis. Chapman \& Hall/CRC, Second Edition, ISBN: 1-58488-388-X. New York.

Spiegelhalter, D. J., Best, N. G., Carlin, B. P., Van Der Linde, A. (2002). Bayesian measures of model complexity and fit. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, \bold{64}(4), pages 583--639.
}

