% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{rPLMIX}
\alias{rPLMIX}
\title{Random sample from a mixture of Plackett-Luce models}
\usage{
rPLMIX(n = 1, K, G, p = t(matrix(1/K, nrow = K, ncol = G)),
  ref_order = t(matrix(1:K, nrow = K, ncol = G)), weights = rep(1/G, G),
  rankingoutput = FALSE)
}
\arguments{
\item{n}{Number of observations to be sampled. Default is 1.}

\item{K}{Number of possible items.}

\item{G}{Number of mixture components.}

\item{p}{Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of component-specific support parameters. Default is equal support parameters (uniform mixture components).}

\item{ref_order}{Numeric \eqn{G}\eqn{\times}{x}\eqn{K} matrix of component-specific reference orders. Default is forward orders (Plackett-Luce mixture components).}

\item{weights}{Numeric vector of \eqn{G} mixture weights. Default is equal weights.}

\item{rankingoutput}{Logical: whether the final simulated dataset should be expressed in the ranking format. Default is \code{FALSE}.}
}
\value{
If \eqn{G=1}, a numeric \eqn{N}\eqn{\times}{x}\eqn{K} matrix of simulated complete sequences. If \eqn{G>1}, a list of two named objects:

 \item{\code{comp}}{ Numeric vector of \code{n} component memberships.}
 \item{\code{sim_data}}{ Numeric \eqn{N}\eqn{\times}{x}\eqn{K} matrix of simulated complete sequences.}
}
\description{
Draw a random sample from a \eqn{G}-component mixture of Plackett-Luce models.
}
\details{
Positive values are required for \code{p} and \code{weights} arguments (normalization is not necessary). A permutation of the first \eqn{K} integers has to be specified for each row of the \code{ref_order} argument. By changing the default setting of the \code{ref_order} argument, a sample from a \eqn{G}-component mixture of Extended Plackett-Luce models is returned.
}
\examples{

library(PLMIX)
K <- 6
G <- 3
support_par <- matrix(1:(G*K), nrow=G, ncol=K)
weights_par <- c(0.50, 0.25, 0.25)
set.seed(47201)
simulated_data <- rPLMIX(n=5, K=K, G=G, p=support_par, weights=weights_par)
simulated_data$comp
simulated_data$sim_data

}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.

Mollica, C., Tardella, L. (2014). Epitope profiling via mixture modeling for ranked data. \emph{Statistics in Medicine}, \bold{33}(21), pages 3738--3758, ISSN: 0277-6715, DOI: 10.1002/sim.6224.
}

