% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_table_pattern.R
\name{rename_table_pattern}
\alias{rename_table_pattern}
\title{simple table name replacement for a given pattern}
\usage{
rename_table_pattern(df, pattern = " ", replacement = "_")
}
\arguments{
\item{df}{dataframe to rename}

\item{pattern}{pattern to replace}

\item{replacement}{value to replace pattern}
}
\description{
simple table name replacement for a given pattern
}
\details{
a helper to easily wrap around reading tables to perform
simple replacement
}
\examples{
\dontrun{
# rename all spaces to underscore
df <- rename_table_pattern(read_table("data/data.csv"))
# rename "-" to "_"
df <- rename_table_pattern(read_table("data/data.csv"), "-", "_")
#rename an existing df
df <-rename_table_pattern(df, "-", "_")
}
}
