% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label_efficiency.R
\name{label_efficiency}
\alias{label_efficiency}
\title{Data preprocessing and efficiency labeling with Additive DEA}
\usage{
label_efficiency(data, REF = data, x, y, RTS = "vrs")
}
\arguments{
\item{data}{A \code{data.frame} or \code{matrix} containing all variables.}

\item{REF}{Optional reference set of inputs that defines the technology
(defaults to the columns indicated by \code{x} in \code{data}). Must have
the same number of rows as \code{data}.}

\item{x}{Integer vector with column indices of input variables in \code{data}.}

\item{y}{Integer vector with column indices of output variables in \code{data}.}

\item{RTS}{Character or integer specifying the DEA technology / returns-to-scale
assumption (default: \code{"vrs"}). Accepted values:
\describe{
\item{\code{0} / \code{"fdh"}}{Free disposability hull (no convexity).}
\item{\code{1} / \code{"vrs"}}{Variable returns to scale (convexity + free disposability).}
\item{\code{2} / \code{"drs"}}{Decreasing returns to scale (convexity, down-scaling, free disposability).}
\item{\code{3} / \code{"crs"}}{Constant returns to scale (convexity + free disposability).}
\item{\code{4} / \code{"irs"}}{Increasing returns to scale (up-scaling only, convexity + free disposability).}
\item{\code{5} / \code{"add"}}{Additivity (integer up/down scaling) with free disposability.}
}}
}
\value{
A \code{data.frame} equal to \code{data} (retaining all input \code{x} and
output \code{y} columns) plus a new factor column \code{class_efficiency}
with levels \code{c("not_efficient","efficient")}.
}
\description{
Labels each DMU (Decision Making Unit) as efficient or not using the
Additive DEA model, optionally after basic data preprocessing. The resulting
factor \code{class_efficiency} has levels \code{c("not_efficient","efficient")},
where \code{"efficient"} is the positive class for downstream modeling.
}
\details{
Internally relies on \code{\link[Benchmarking]{dea.add}} to compute Additive DEA
scores and derive the binary efficiency label.
}
\examples{
# Example (assuming columns 1:2 are inputs and 3 is output):
# out <- my_fun(data = df, x = 1:2, y = 3, RTS = "vrs")
# table(out$class_efficiency)

}
\seealso{
\code{\link[Benchmarking]{dea.add}}
}
