% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MixedGaussian.R
\name{MixedGaussian}
\alias{MixedGaussian}
\title{Create a multi-regime Gaussian model (MixedGaussian)}
\usage{
MixedGaussian(
  k,
  modelTypes,
  mapping,
  className = paste0("MixedGaussian_", do.call(paste0, as.list(mapping))),
  X0 = structure(0, class = c("VectorParameter", "_Global"), description =
    "trait values at the root"),
  ...,
  Sigmae_x = structure(0, class = c("MatrixParameter", "_UpperTriangularWithDiagonal",
    "_WithNonNegativeDiagonal", "_Global"), description =
    "Upper triangular factor of the non-phylogenetic variance-covariance")
)
}
\arguments{
\item{k}{integer specifying the number of traits.}

\item{modelTypes, mapping}{These two arguments define the mapping between the
regimes in the model and actual types of models. For convenience, different
combinations are possible as explained below:
\itemize{
\item \code{modelTypes} is a (possibly named) character string vector. Each
such string denotes a mixed Gaussian regime model class, e.g. the result of calling
\code{MGPMDefaultModelTypes()}. In that case \code{mapping} can be either
an integer vector with values corresponding to indices in \code{modelTypes}
or a character string vector. If \code{mapping} is a character string vector,
first it is matched against \code{names(modelTypes)} and if the match fails
either because of \code{names(modelTypes)} being \code{NULL} or because some
of the entries in \code{mapping} are not present in \code{names(modelTypes)},
then an attempt is made to match \code{mapping} against \code{modelTypes},
i.e. it is assumed that \code{mapping} contains actual class names.
\item \code{modelTypes} is a (possibly named) list of PCM models of
\code{k} traits. In this case \code{mapping} can again be an integer vector
denoting indices in \code{modelTypes} or a character string vector denoting
names in \code{modelTypes}.
}
As a final note, \code{mapping} can also be named. In this case the names are
assumed to be the names of the different regimes in the model. If
\code{mapping} is not named, the regimes are named automatically as
\code{as.character(seq_len(mapping))}.  For example, if
\code{modelTypes = c("BM", "OU")} and
\code{mapping = c(a = 1, b = 1, c = 2, d = 1)} defines an MixedGaussian with
four different regimes named 'a', 'b', 'c', 'd', and  model-types
BM, BM, OU and BM, corresponding to each regime.}

\item{className}{a character string defining a valid S3 class name for the
resulting MixedGaussian object. If not specified, a className is generated
using the expression
\code{ paste0("MixedGaussian_", do.call(paste0, as.list(mapping)))}.}

\item{X0}{specification for the global vector X0 to be used by all
models in the MixedGaussian.}

\item{...}{specifications for other _Global parameters coming after X0.}

\item{Sigmae_x}{sepcification of a _Global Sigmae_x parameter. This is used
by Submodels only if they have Sigmae_x _Omitted.}
}
\value{
an object of S3 class className inheriting from MixedGaussian,
GaussianPCM and PCM.
}
\description{
Create a multi-regime Gaussian model (MixedGaussian)
}
\details{
If X0 is not NULL it has no sense to use model-types including X0 as
a parameter (e.g. use BM1 or BM3 instead of BM or BM2). Similarly if Sigmae_x
is not NULL there is no meaning in using model-types including Sigmae_x as a
parameter, (e.g. use OU2 or OU3 instead of OU or OU1).
}
\seealso{
\code{\link{PCMTreeGetPartNames}}

\code{\link{PCMModels}()}
}
