% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paired_equivalence_data_frame.R,
%   R/paired_equivalence_default.R, R/paired_equivalence_generic.R
\name{paired_equivalence_test.data.frame}
\alias{paired_equivalence_test.data.frame}
\alias{paired_equivalence_test.default}
\alias{paired_equivalence_test}
\title{Perform equivalence testing on paired samples}
\usage{
\method{paired_equivalence_test}{data.frame}(
  x,
  y,
  y_type = c("both", "criterion", "comparison"),
  alpha = 0.05,
  na.rm = TRUE,
  scale = c("relative", "absolute"),
  absolute_region_width = NULL,
  relative_region_width = NULL,
  ...
)

\method{paired_equivalence_test}{default}(
  x,
  y,
  y_type = c("both", "criterion", "comparison"),
  alpha = 0.05,
  na.rm = TRUE,
  scale = c("relative", "absolute"),
  absolute_region_width = NULL,
  relative_region_width = NULL,
  ...
)

paired_equivalence_test(
  x,
  y,
  y_type = c("both", "criterion", "comparison"),
  alpha = 0.05,
  na.rm = TRUE,
  scale = c("relative", "absolute"),
  absolute_region_width = NULL,
  relative_region_width = NULL,
  ...
)
}
\arguments{
\item{x}{numeric vector representing the (possibly surrogate) sample}

\item{y}{numeric vector representing the (possibly criterion) sample. Index
paired with \code{x}}

\item{y_type}{classification of \code{y} for the purpose of analysis. Can be
\code{"criterion"}, \code{"comparison"}, or \code{"both"}.}

\item{alpha}{the alpha level for the test}

\item{na.rm}{logical. Omit mean values for mean calculations?}

\item{scale}{character specifying whether the test should occur on an
absolute or relative scale. Must be one of \code{"relative"} (default) or
\code{"absolute"}.}

\item{absolute_region_width}{the region width for use when \code{scale =
"absolute"}}

\item{relative_region_width}{the region width for use when \code{scale =
"relative"}}

\item{...}{further arguments passed to methods. Currently unused.}
}
\value{
a `paired_equivalence` object summarizing the test input and results
}
\description{
Perform equivalence testing on paired samples
}
\note{
If a value is not specified for the region width that corresponds with
  \code{scale}, a default value will be assigned with a warning.
}
\examples{
set.seed(1544)
x <- data.frame(
  var1 = rnorm(500, 15, 4),
  var2 = rnorm(500, 23, 7.3)
)
y <- rnorm(500, 17.4, 9)

test_result <- paired_equivalence_test(
  x, y, relative_region_width = 0.25
)

lapply(test_result, head)

}
\references{
\href{https://pubmed.ncbi.nlm.nih.gov/29135817/}{Dixon et al.}
}
