% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{WHEATSPAIN}
\alias{WHEATSPAIN}
\title{Wheat Surface Area in Spain}
\format{A data frame with 17 observations on the following 3 variables:
\itemize{
\item \code{community} (a factor with levels \code{Andalucia}, \code{Aragon}, \code{Asturias}, \code{Baleares}, \code{C.Valenciana}, \code{Canarias}, \code{Cantabria}, \code{Castilla-La Mancha}, \code{Castilla-Leon}, \code{Cataluna}, \code{Extremadura}, \code{Galicia}, \code{La Rioja}, \code{Madrid}, \code{Murcia}, \code{Navarra}, and \code{P.Vasco})
\item \code{hectares} (surface area measured in hectares)
\item \code{acres} (surface area measured in acres)
}}
\usage{
WHEATSPAIN
}
\description{
Seventeen Spanish communities and their corresponding surface area (in hecatares) dedicated to growing wheat
}
\examples{
ggplot(data = WHEATSPAIN, aes(x = reorder(community, acres), y = acres)) +
geom_bar(stat="identity", color = "orange", fill = "gold") + coord_flip() +
labs(x = "")
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}

