% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{data}
\name{BABERUTH}
\alias{BABERUTH}
\title{George Herman Ruth}
\format{A data frame with 22 observation of the following 14 variables:
\itemize{
\item\code{year} (year in which the season occurred)
\item \code{team} (team for which he played \code{Bos-A}, \code{Bos-N}, or \code{NY-A})
\item \code{g} (games played)
\item \code{ab} (at bats)
\item \code{r} (runs scored)
\item \code{h} (hits)
\item \code{X2b} (doubles)
\item \code{X3b} (triples)
\item \code{hr} (home runs)
\item \code{RBI} (runs batted in)
\item \code{sb} (stolen bases)
\item \code{bb} (base on balls or walks)
\item \code{ba} (batting average = h/ab)
\item \code{slg} (slugging percentage = total bases/at bats)
}}
\source{
\url{http://www.baseball-reference.com/about/bat_glossary.shtml}
}
\usage{
BABERUTH
}
\description{
Baseball statistics for George Herman Ruth (The Bambino or the Sultan of Swat)
}
\examples{
ggplot(data = BABERUTH, aes(x = ba)) + geom_histogram(binwidth = 0.03) +
facet_grid(team ~ .) + labs(x = "Batting average")
ggplot(data = BABERUTH, aes(x = g, y = ab, color = rbi)) + geom_point() +
labs(x = "Number of Games Played", y = "Times at Bat", color = "Runs\\n Batted In",
title = "George Herman Ruth")
}
\references{
Ugarte, M. D., Militino, A. F., and Arnholt, A. T. 2015. \emph{Probability and Statistics with R}, Second Edition. Chapman & Hall / CRC.
}
\keyword{datasets}

