% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateFiles.R
\name{updateFiles}
\alias{updateFiles}
\title{Update Location of Files in an AcousticStudy}
\usage{
updateFiles(x, bin = NULL, db = NULL, recording = NULL, verbose = TRUE)
}
\arguments{
\item{x}{an \linkS4class{AcousticStudy} or \linkS4class{AcousticEvent}
object}

\item{bin}{folder containing updated binary file locations. If
\code{NULL} (default), user will be prompted to select a folder.
If \code{NA}, binary files will be skipped.}

\item{db}{single file or folder containing updated database file locations.
\code{NULL} (default), user will be prompted to select a folder.
If \code{NA}, database files will be skipped.}

\item{recording}{folder containing updated recording file locations. If
\code{NULL} (default), user will be prompted to select a folder.
If \code{NA}, recording files will be skipped.}

\item{verbose}{logical flag to print messages about success of replacement}
}
\value{
the same \linkS4class{AcousticStudy} and
  \linkS4class{AcousticEvent} object as \code{x} with
  updated file locations
}
\description{
Updates the stored locations of binary, database, and/or recording
  files in the \code{files} slots of an \linkS4class{AcousticStudy} and all
  \linkS4class{AcousticEvent} objects within. Runs interactively to prompt
  users to select folders if missing files are found. Typically used after changing
  computers, or if original data was on an external hard drive. If any
  missing files are not able to be located, they will be kept in the files
  slot so that this function can be run again
}
\examples{

data(exStudy)
# files in exStudy will have paths local to package creator's computer
files(exStudy)$db
file.exists(files(exStudy)$db)
files(exStudy)$binaries
file.exists(files(exStudy)$binaries)
# folder with example DB
db <- system.file('extdata', package='PAMpal')
# folder with example binaries
bin <- system.file('extdata', 'Binaries', package='PAMpal')
exStudy <- updateFiles(exStudy, db=db, bin=bin)
files(exStudy)$db
file.exists(files(exStudy)$db)
files(exStudy)$binaries
file.exists(files(exStudy)$binaries)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
