% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ostats_plot.R
\name{Ostats_plot}
\alias{Ostats_plot}
\title{Plot community trait overlap}
\usage{
Ostats_plot(
  plots,
  sp,
  traits,
  overlap_dat = NULL,
  use_plots = NULL,
  n_col = 1,
  scale = "fixed",
  colorvalues = NULL,
  alpha = 0.5,
  adjust = 2,
  limits_x = c(0.5, 1.5),
  legend = FALSE,
  name_x = "trait value",
  name_y = "probability density",
  means = FALSE
)
}
\arguments{
\item{plots}{Site identity: a vector of names of each community.}

\item{sp}{Taxon identity: a vector of species or taxa names.}

\item{traits}{A vector of trait measurements for each individual, or a matrix
or data frame with rows representing individuals and columns representing traits.}

\item{overlap_dat}{Optional: an object containing the output of \code{\link{Ostats}}.
If provided, overlap statistics will be displayed in the plot panels.}

\item{use_plots}{a vector of sites to plot. If NULL, the function will plot all the sites.}

\item{n_col}{Number of columns for layout of individual panels. Default is 1.}

\item{scale}{If you want the scale of x, y or both x and y axis to be independent,
set the argument to "free_x", "free_y" or "free" respectively.
Default = "fixed" which uses the same scale across all sites.
See \code{\link[ggplot2]{facet_grid}}.}

\item{colorvalues}{Vector of color values for the density polygons.
Defaults to a viridis palette if none provided.}

\item{alpha}{defines the transparency level for the density polygons. Default is 0.5.}

\item{adjust}{the bandwidth adjustment of the density polygons. Default is 2.
See \code{\link[stats]{density}}.}

\item{limits_x}{Vector of length 2, with multiplicative factor to apply to the minimum
and maximum values of each trait to expand the limits of the x axis.
Default is 0.5 times the minimum and 1.5 times the maximum value of each trait.}

\item{legend}{Whether to include a legend. Defaults to \code{FALSE}.}

\item{name_x}{x-axis label. Default is 'trait value'}

\item{name_y}{y-axis label. Default is 'probability density'}

\item{means}{if TRUE, trait means for each species are plotted in an additional plot
column next to the traits distribution plots for each site. Default is}
}
\value{
Density plots of species trait distributions plotted together
 for each community to show how they overlap each other.
 The overlap value obtained as output from \code{\link{Ostats}}
 is labelled on each community graph, if provided by the user.

 The class of the returned object is \code{Ostats_plot_object}. Calling
 \code{print} on this object will invoke a method to draw the plot using
 \code{\link[grid]{grid.draw}}.

 If more than one trait is provided, a list of objects of class
 \code{Ostats_plot_object} will be returned.
}
\description{
This function plots the overlap of traits among
 species for each community. If there are multiple traits,
 each trait is plotted separately in one-dimensional space.
}
\examples{
# set the arguments:
plots <- small_mammal_data$siteID
sp <- small_mammal_data$taxonID
traits <- log10(small_mammal_data$weight)

# to plot only selected sites:
use_plots <- c('BART','KONZ','JORN')


Ostats_plot(plots = plots, sp = sp, traits = traits,
           overlap_dat = small_mammal_Ostats,
           use_plots = use_plots, means = TRUE)
}
\seealso{
\code{\link{Ostats}} to Calculate O-statistics (community-level
 pairwise niche overlap statistics)
}
