% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimization_methods.R
\name{optimize_design_onestage}
\alias{optimize_design_onestage}
\title{Calculate optimal design parameters for a single-stage gold-standard design}
\usage{
optimize_design_onestage(
  cP1 = NULL,
  cC1 = NULL,
  alpha = 0.025,
  beta = 0.2,
  alternative_TP = 0.4,
  alternative_TC = 0,
  Delta = 0.2,
  varT = 1,
  varP = 1,
  varC = 1,
  round_n = TRUE,
  kappa = 0,
  objective = quote(sum(unlist(n)) + kappa * n[[1]][["P"]]),
  inner_tol_objective = 1e-07,
  mvnorm_algorithm = mvtnorm::Miwa(steps = 4097, checkCorr = FALSE, maxval = 1000),
  nloptr_x0 = NULL,
  nloptr_lb = NULL,
  nloptr_ub = NULL,
  nloptr_opts = list(algorithm = "NLOPT_LN_SBPLX", ftol_rel = 1e-09, xtol_abs = 1e-08,
    xtol_rel = 1e-07, maxeval = 1000, print_level = 0),
  print_progress = TRUE,
  ...
)
}
\arguments{
\item{cP1}{(numeric) allocation ratio nP1 / nT1. Parameter to be optimized if left unspecified.}

\item{cC1}{(numeric) allocation ratio nC1 / nT1. Parameter to be optimized if left unspecified.}

\item{alpha}{type I error rate.}

\item{beta}{type II error rate.}

\item{alternative_TP}{assumed difference between T and P under H1. Positive values favor T.}

\item{alternative_TC}{assumed difference between T and C under H1. Positive values favor T.}

\item{Delta}{non-inferiority margin for the test \eqn{X_T - X_C \leq - \Delta} vs.
\eqn{X_T - X_C > - \Delta}.}

\item{varT}{variance of treatment group.}

\item{varP}{variance of placebo group.}

\item{varC}{variance of control group.}

\item{round_n}{(logical) if TRUE, a design with integer valued sample sizes is returned.}

\item{kappa}{(numeric) penalty factor for placebo patients in the default objective function.}

\item{objective}{(expression) objective criterion.}

\item{inner_tol_objective}{(numeric) used to determine the tolerances for integrals and nuisance optimization problems
inside the objective function.}

\item{mvnorm_algorithm}{algorithm for multivariate integration passed to \code{\link[mvtnorm]{pmvnorm}}.}

\item{nloptr_x0}{(numeric vector) starting point for optimization.}

\item{nloptr_lb}{(numeric vector) lower bound box for box constrained optimization.}

\item{nloptr_ub}{(numeric vector) upper bound box for box constrained optimization.}

\item{nloptr_opts}{(list) nloptr options. See \code{\link[nloptr]{nloptr}}.}

\item{print_progress}{(logical) controls whether optimization progress should be visualized during the calculation.}

\item{...}{additional arguments passed along.}
}
\value{
Design object (a list) with optimized design parameters.
}
\description{
Calculate optimal design parameters for a single-stage gold-standard design
}
\details{
This function calculates optimal design parameters for a two-stage three-arm gold-standard
non-inferiority trial. Run \code{vignette("Introduction", package = "OptimalGoldstandardDesigns")}
to see some examples related to the associated paper \insertCite{meis2023optimization}{OptimalGoldstandardDesigns}.

Parameters which can be optimized are the allocation ratios for all groups and stages and the
futility and efficacy boundaries of the first stage. The allocation ratios are
cT2 = nT2 / nT1, cP1 = nP1 / nT1,
cP2 = nP2 / nT1, cC1 = nC1 / nT1 and cC2 = nC2 / nT1. Here, nT1 denotes the sample size
of the treatment group in the first stage, nP2 the sample size of the placebo group in the
second stage, etc. The first stage efficacy boundaries are bTP1e for the treatment vs
placebo testing problem, and bTC1e for the treatment vs control non-inferiority testing
problem. The futility boundaries are denoted by bTP1f and bTC1f.

If these parameters are left unspecified or set to NULL, they will be included into the
optimization process, otherwise they will be considered boundary constraints.
You may also supply quoted expressions as arguments for these
parameters to solve a constrained optimization problem. For example, you can supply
\code{cT2 = 1, cP2 = quote(cP1), cC2 = quote(cC1)} to ensure that the first and second
stage allocation ratios are equal.

The design is optimized with respect to the objective criterion given by the parameter
\code{objective}. By default, this is the overall sample size plus an optional
penalty for the placebo group sample size, controlled by the parameter \code{kappa}.

Designs are calculated to fulfill the following constraints: the family-wise type I error
rate is controlled at \code{alpha} under any combination of the two null hypotheses
\code{muT - muP = 0} and \code{muT - muC + Delta = 0}.
The power to reject both hypothesis given both alternative
hypotheses \code{muT - muP = alternative_TP} and \code{muT - muC + Delta = alternative_TC + Delta}
is at least \code{1 - beta}. Variances are assumed to be given by \code{varT, varP} and \code{varC}.

If \code{binding_futility} is \code{TRUE}, type I error recycling is used.
If \code{always_both_futility_tests} is \code{TRUE}, it is assumed that futility tests for both
hypotheses are performed at interim, regardless of whether the treatment vs placebo null hypothesis
was successfully rejected. If \code{always_both_futility_tests} is \code{FALSE}, the futility
test for the treatment vs. control testing problem only needs to be done if the null for the
treatment vs. placebo testing problem was rejected in the first stage.
}
\examples{
# Should take about 2 second with the chosen accuracy
optimize_design_onestage(
  alpha = .025,
  beta = .2,
  alternative_TP = .4,
  alternative_TC = 0,
  Delta = .2,
  mvnorm_algorithm = mvtnorm::Miwa(steps = 512, checkCorr = FALSE, maxval = 1000),
  nloptr_opts = list(algorithm = "NLOPT_LN_SBPLX", ftol_rel = 1e-03, xtol_abs = 1e-08,
                     xtol_rel = 1e-07, maxeval = 1000, print_level = 0)
)

}
\references{
\insertAllCited{}
}
