% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.r
\name{importExcel}
\alias{importExcel}
\title{Import grid data from an Excel file.}
\usage{
importExcel(file, dir = NULL, sheetIndex = 1, min = NULL, max = NULL)
}
\arguments{
\item{file}{A vector of filenames including the full path if file is not in current working 
directory. The file suffix has to be \code{.xlsx} (used since Excel 2007).}

\item{dir}{Alternative way to supply the directory where the file is located 
(default \code{NULL}).}

\item{sheetIndex}{The number of the Excel sheet that contains the grid data.}

\item{min}{Optional argument (\code{numeric}, default \code{NULL})
for minimum rating value in grid.}

\item{max}{Optional argument (\code{numeric}, default \code{NULL})
for maximum rating value in grid.}
}
\value{
A single \code{repgrid} object in case one file and
               a list of \code{repgrid} objects in case multiple files are imported.
}
\description{
You can define a grid using Microsoft Excel and by saving it as a
\code{.xlsx} file. The \code{.xlsx} file has to be in a specified fixed 
format (see section Details).
}
\details{
Excel file structure: The first row contains the minimum of the rating scale,
the names of the elements and the maximum of the rating scale. Below every
row contains the left construct pole, the ratings and the right construct
pole.

\tabular{lccccr}{
\code{1}           \tab \code{E1}  \tab \code{E2} \tab \code{E3} \tab \code{E4}  \tab \code{5}        \cr
\code{left pole 1} \tab \code{1}   \tab \code{5}  \tab \code{3}  \tab \code{4}   \tab \code{right pole 1} \cr
\code{left pole 2} \tab \code{3}   \tab \code{1}  \tab \code{1}  \tab \code{3}   \tab \code{right pole 2} \cr
\code{left pole 3} \tab \code{4}   \tab \code{2}  \tab \code{5}  \tab \code{1}   \tab \code{right pole 3} \cr
}

Note that the maximum and minimum value has to be defined using the
\code{min} and \code{max} arguments if no values are supplied at the
beginning and end of the first row. Otherwise the scaling range is inferred
from the available data and a warning is issued as the range may be
erroneous. This may effect other functions that depend on knowing the correct
range and it is thus strongly recommended to set the scale range correctly.
}
\examples{
\dontrun{

# Open Excel file delivered along with the package
file <- system.file("extdata", "grid_01.xlsx", package = "OpenRepGrid")
rg <- importExcel(file)

# To see the structure of the Excel file try to open it as follows.
# Requires Excel to be installed.
system2("open", file)

# Import more than one Excel file
files <- system.file("extdata", c("grid_01.xlsx", "grid_02.xlsx") , package = "OpenRepGrid")
rg <- importExcel(files)

}

}
\seealso{
\code{\link{importGridcor}},
               \code{\link{importGridstat}},
               \code{\link{importScivesco}},
               \code{\link{importGridsuite}},
               \code{\link{importTxt}}
}
