% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxUnitTesting.R
\name{omxCheckWarning}
\alias{omxCheckWarning}
\title{Correct Warning Message Function}
\usage{
omxCheckWarning(expression, message)
}
\arguments{
\item{expression}{an R expression that produces a warning}

\item{message}{a character string with the desired warning message}
}
\description{
This function tests whether the correct warning message is thrown.
Arguments \sQuote{expression} and \sQuote{message} give the expression
that generates the warning and the message that is supposed to be generated, respectively.
}
\details{
\emph{note}: to test for no warning, set \code{message = NA}.
}
\examples{
foo <- omxCheckWarning(mxFIMLObjective('cov', 'mean'), "deprecated")

# Test for no warning
omxCheckWarning(2+2, message = NA)

}
\references{
The OpenMx User's guide can be found at http://openmx.ssri.psu.edu/documentation.
}
\seealso{
\code{\link{omxCheckError}}
\code{\link{omxCheckWithinPercentError}},
\code{\link{omxCheckIdentical}}, \code{\link{omxCheckSetEquals}},
\code{\link{omxCheckTrue}}, \code{\link{omxCheckEquals}}
}
