% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Network.R
\name{Network}
\alias{Network}
\title{R6Class Network}
\description{
Wrapper class for the \code{network} C struct (\emph{network.h}).

Network object has information about a specific network.

the network ID
.c_network External pointer, reference to \code{network} C struct.
the C network R pointer object
check the C network still exists
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{c_network}}{the C network R pointer object (SWIG wrapped)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Network$new()}}
\item \href{#method-n_edges}{\code{Network$n_edges()}}
\item \href{#method-n_vertices}{\code{Network$n_vertices()}}
\item \href{#method-name}{\code{Network$name()}}
\item \href{#method-network_id}{\code{Network$network_id()}}
\item \href{#method-skip_hospitalised}{\code{Network$skip_hospitalised()}}
\item \href{#method-skip_quarantined}{\code{Network$skip_quarantined()}}
\item \href{#method-type}{\code{Network$type()}}
\item \href{#method-daily_fraction}{\code{Network$daily_fraction()}}
\item \href{#method-transmission_multiplier}{\code{Network$transmission_multiplier()}}
\item \href{#method-set_transmission_multiplier}{\code{Network$set_transmission_multiplier()}}
\item \href{#method-update_daily_fraction}{\code{Network$update_daily_fraction()}}
\item \href{#method-print}{\code{Network$print()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$new(model, network_id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{R6 Model object}

\item{\code{network_id}}{The network ID.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-n_edges"></a>}}
\if{latex}{\out{\hypertarget{method-n_edges}{}}}
\subsection{Method \code{n_edges()}}{
Wrapper for C API \code{network_n_edges}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$n_edges()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Number of edges
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-n_vertices"></a>}}
\if{latex}{\out{\hypertarget{method-n_vertices}{}}}
\subsection{Method \code{n_vertices()}}{
Wrapper for C API \code{network_n_vertices}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$n_vertices()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Number of vertices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-name"></a>}}
\if{latex}{\out{\hypertarget{method-name}{}}}
\subsection{Method \code{name()}}{
Wrapper for C API \code{network_name}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$name()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The network name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-network_id"></a>}}
\if{latex}{\out{\hypertarget{method-network_id}{}}}
\subsection{Method \code{network_id()}}{
Wrapper for C API \code{get_network_by_id}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$network_id()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The network ID
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skip_hospitalised"></a>}}
\if{latex}{\out{\hypertarget{method-skip_hospitalised}{}}}
\subsection{Method \code{skip_hospitalised()}}{
Wrapper for C API \code{network_skip_hospitalised}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$skip_hospitalised()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if interactions are skipped for hospitalised
persons.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skip_quarantined"></a>}}
\if{latex}{\out{\hypertarget{method-skip_quarantined}{}}}
\subsection{Method \code{skip_quarantined()}}{
Wrapper for C API \code{network_skip_quarantined}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$skip_quarantined()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if interactions are skipped for quarantined
persons.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-type"></a>}}
\if{latex}{\out{\hypertarget{method-type}{}}}
\subsection{Method \code{type()}}{
Wrapper for C API \code{network_type}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Network type: 0 (household), 1 (occupation), or 2 (random)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-daily_fraction"></a>}}
\if{latex}{\out{\hypertarget{method-daily_fraction}{}}}
\subsection{Method \code{daily_fraction()}}{
Wrapper for C API \code{network_daily_fraction}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$daily_fraction()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The fraction of edges on the network present each day (i.e.
down-sampling the network). Value between 0 and 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-transmission_multiplier"></a>}}
\if{latex}{\out{\hypertarget{method-transmission_multiplier}{}}}
\subsection{Method \code{transmission_multiplier()}}{
Wrapper for C API \code{network_transmission_multiplier}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$transmission_multiplier()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The transmission multiplier for this network
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_transmission_multiplier"></a>}}
\if{latex}{\out{\hypertarget{method-set_transmission_multiplier}{}}}
\subsection{Method \code{set_transmission_multiplier()}}{
Wrapper for C API \code{set_network_transmission_multiplier}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$set_transmission_multiplier(val)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{val}}{New tranmission multiplier value to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Sets the transmission multiplier for this network
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update_daily_fraction"></a>}}
\if{latex}{\out{\hypertarget{method-update_daily_fraction}{}}}
\subsection{Method \code{update_daily_fraction()}}{
Wrapper for C API \code{update_daily_fraction}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$update_daily_fraction(daily_fraction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{daily_fraction}}{New fraction value; a value between 0 and 1.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} on success, \code{FALSE} on failure.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Network$print()}\if{html}{\out{</div>}}
}

}
}
