% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{plot_confidence_set}
\alias{plot_confidence_set}
\title{Plots the "confidence set" according to the observed responses.}
\usage{
plot_confidence_set(t, u, r1, n1, n, pc0, pt0, alpha)
}
\arguments{
\item{t}{observed responses in the subset endpoint.}

\item{u}{observed responses in the superset endpoint.}

\item{r1}{critical value for the first stage.}

\item{n1}{sample size for the first stage.}

\item{n}{overall sample size.}

\item{pc0}{the response probability for the subset endpoint under the null hypothesis.}

\item{pt0}{the response probability for the superset endpoint under the null hypothesis.}

\item{alpha}{overall significance level the trial was planned for.}
}
\description{
Plots the "confidence set" which can be received by invoking "get_confidence_set". Also the "uniformly minimal variance unbiased estimator" and the acceptance area are included in the plot.
}
\examples{
\dontrun{
#Setup "sub1"-object
sub1 <- setupSub1Design(pc0 = 0.5, pt0 = 0.6)

#Calculate a  subset design
design <- getSolutionsSub1(sub1, skipN1 = FALSE)$Solutions[4,]

#Assume 11 responses in the subset endpoint and 12 responses in the superset endpoint were observed.
t = 10
u = 12

plot_confidence_set(t, u, design$r1, design$n1, design$n, design$pc0, design$pt0, 0.1)
}
}
\references{
Kunz, C. U.  (2011), Two-stage designs for phase II trials with one or two endpoints. http://d-nb.info/1024218457
}
\seealso{
\code{\link{get_confidence_set}}, \code{\link{get_UMVUE_GMS_subset_second_total}}, \code{\link{get_UMVUE_GMS}}
}

