% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{get_r2_flex}
\alias{get_r2_flex}
\title{Calculates the number of responses needed for the second stage.}
\usage{
get_r2_flex(ce, p0, n2)
}
\arguments{
\item{ce}{conditional error for the second stage.}

\item{p0}{probability for a response under the null hypothesis.}

\item{n2}{sample size for the second stage.}
}
\description{
Calculates the number of responses needed for the second stage of a Simon's two-stage design if the flexible extension is chosen in the planning phase.
}
\examples{
\dontrun{
#Calculate a Simon's two-stage design
design <- getSolutions()$Solutions[3,] #minimax-design for the default values.
#Get the conditional error values using proportionally "rest"-alpha spending.
ce_df <- getD_proportionally(design, 0.05)
#Assume 5 responses were observed in the interim analysis.
ce <- ce_df[5+1,]$ce # conditional error for 5 responses is listed in the 6th row of "ce_df"
#Calculate the number of patients needed in the second stage.
n2 <- design$n - design$n1
r2 <- get_r2_flex(ce, design$p0, n2)
r2
#Assume 10 patients more should be recruited in the second stage. 
#(This changes the number of needed responses.)
n2 <- n2 + 10
r2 <- get_r2_flex(ce, design$p0, n2)
r2
}
}
\seealso{
\code{\link{getD_proportionally}}, \code{\link{getD_equally}}, \code{\link{getD_distributeToOne}}, \code{\link{getD_none}}
}

