# logo

    Code
      cat(uiStatic(logo = "my_pic.png"), sep = "\n")
    Output
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "my_pic.png",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

# empty shiny

    Code
      cat(uiStatic(), sep = "\n")
    Output
      ui <- bslib::page_navbar(
        title = "",
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(serverStatic(), sep = "\n")
    Output
      server <- function(input, output, session) {
        # download raw data -----
        output$download_raw <- shiny::downloadHandler(
          filename = "results.csv",
          content = function(file) {
            OmopViewer::exportSummarisedResult(data, fileName = file)
          }
        )
      }

# title

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          "example"
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

# order tabs

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_panel(
          title = "Cohort count",
          icon = shiny::icon("users"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_count_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_count_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_count_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_gt_9_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_gt_9_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "variable_name", "estimate_name"),
                          input_id = "summarise_cohort_count_gt_9_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "cohort_name",
                          input_id = "summarise_cohort_count_gt_9_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_cohort_count_gt_9_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_count_gt_9_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_count_gt_9")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_ggplot2_10_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_facet",
                        label = "facet",
                        selected = "cdm_name",
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_count_ggplot2_10")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort overlap",
          icon = shiny::icon("circle-half-stroke"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("Cohort overlap shows the number of subjects that contribute to a pair of cohorts.")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_overlap_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_overlap_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_gt_1_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_gt_1_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cohort_name_reference", "cohort_name_comparator", "estimate_name"),
                          input_id = "summarise_cohort_overlap_gt_1_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_overlap_gt_1_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = "cdm_name",
                          input_id = "summarise_cohort_overlap_gt_1_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_overlap_gt_1_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_gt_1_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_overlap_gt_1")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_ggplot2_2_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_overlap_ggplot2_2")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort Attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_cohort_definition_id",
                    label = "Cohort definition id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_gt_3_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_gt_3_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = "reason",
                          input_id = "summarise_cohort_attrition_gt_3_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_attrition_gt_3_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "cohort_name"),
                          input_id = "summarise_cohort_attrition_gt_3_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = c("variable_level", "reason_id", "estimate_name"),
                          input_id = "summarise_cohort_attrition_gt_3_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_attrition_gt_3")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Diagram",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_width",
                        label = "Width (px)",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_height",
                        label = "Height (px)",
                        value = 10
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_grViz_4_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    DiagrammeR::grVizOutput("summarise_cohort_attrition_grViz_4")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_panel(
          title = "Cohort overlap",
          icon = shiny::icon("circle-half-stroke"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("Cohort overlap shows the number of subjects that contribute to a pair of cohorts.")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_overlap_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_overlap_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_gt_1_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_gt_1_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cohort_name_reference", "cohort_name_comparator", "estimate_name"),
                          input_id = "summarise_cohort_overlap_gt_1_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_overlap_gt_1_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = "cdm_name",
                          input_id = "summarise_cohort_overlap_gt_1_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_overlap_gt_1_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_gt_1_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_overlap_gt_1")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_ggplot2_2_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_overlap_ggplot2_2")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort Attrition",
          icon = shiny::icon("layer-group"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_cohort_definition_id",
                    label = "Cohort definition id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason",
                    label = "Reason",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_grouping_reason_id",
                    label = "Reason id",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_attrition_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_attrition_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_attrition_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort attrition",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_attrition_gt_3_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_gt_3_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = "reason",
                          input_id = "summarise_cohort_attrition_gt_3_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_attrition_gt_3_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = c("cdm_name", "cohort_name"),
                          input_id = "summarise_cohort_attrition_gt_3_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = c("variable_level", "reason_id", "estimate_name"),
                          input_id = "summarise_cohort_attrition_gt_3_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_attrition_gt_3")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Diagram",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_width",
                        label = "Width (px)",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_attrition_grViz_4_download_height",
                        label = "Height (px)",
                        value = 10
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_attrition_grViz_4_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(,
                      position = "right"
                    ),
                    DiagrammeR::grVizOutput("summarise_cohort_attrition_grViz_4")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Cohort count",
          icon = shiny::icon("users"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("")
                ),
                bslib::accordion_panel(
                  title = "Settings",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_settings_table_name",
                    label = "Table name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_grouping_cohort_name",
                    label = "Cohort name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_count_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_count_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_count_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_count_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_gt_9_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_gt_9_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cdm_name", "variable_name", "estimate_name"),
                          input_id = "summarise_cohort_count_gt_9_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "cohort_name",
                          input_id = "summarise_cohort_count_gt_9_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = NULL,
                          input_id = "summarise_cohort_count_gt_9_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_count_gt_9_hide"
                        )
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_count_gt_9")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort count",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_count_ggplot2_10_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_count_ggplot2_10_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_facet",
                        label = "facet",
                        selected = "cdm_name",
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_count_ggplot2_10_colour",
                        label = "colour",
                        selected = NULL,
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_count_ggplot2_10")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

---

    Code
      cat(ui, sep = "\n")
    Output
      # Generated by OmopViewer 0.1.0
      # Be careful editing this file
      
      ui <- bslib::page_navbar(
        title = shiny::tags$span(
          shiny::tags$img(
            src = "ohdsi_logo.svg",
            width = "auto",
            height = "46px",
            class = "me-3",
            alt = "logo"
          ),
          ""
        ),
        bslib::nav_panel(
          title = "Background",
          icon = shiny::icon("disease"),
          OmopViewer::cardFromMd("background.md")
        ),
        bslib::nav_panel(
          title = "Summary",
          icon = shiny::icon("file-alt"),
          OmopViewer::cardSummary(data)
        ),
        bslib::nav_menu(
          title = "DETAILS",
          icon = shiny::icon("list"),
          bslib::nav_panel(
            title = "Cohort count",
            icon = shiny::icon("users"),
            bslib::layout_sidebar(
              sidebar = bslib::sidebar(
                bslib::accordion(
                  bslib::accordion_panel(
                    title = "Information",
                    icon = shiny::icon("info"),
                    shiny::p("")
                  ),
                  bslib::accordion_panel(
                    title = "Settings",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_count_settings_table_name",
                      label = "Table name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  ),
                  bslib::accordion_panel(
                    title = "grouping",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_count_grouping_cdm_name",
                      label = "Cdm name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    ),
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_count_grouping_cohort_name",
                      label = "Cohort name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  ),
                  bslib::accordion_panel(
                    title = "Variables",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_count_variable_name",
                      label = "Variable name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  ),
                  bslib::accordion_panel(
                    title = "Estimates",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_count_estimate_name",
                      label = "Estimate name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  )
                )
              ),
              bslib::navset_card_tab(
                bslib::nav_panel(
                  title = "Tidy",
                  bslib::card(
                    full_screen = TRUE,
                    bslib::card_header(
                      bslib::popover(
                        shiny::icon("download"),
                        shiny::downloadButton(outputId = "summarise_cohort_count_tidy_download", label = "Download csv")
                      ),
                      class = "text-end"
                    ),
                    bslib::layout_sidebar(
                      sidebar = bslib::sidebar(
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_count_tidy_columns",
                          label = "Columns",
                          choices = NULL,
                          selected = NULL,
                          multiple = TRUE,
                          options = list(plugins = "remove_button")
                        ),
                        shiny::radioButtons(
                          inputId = "summarise_cohort_count_tidy_pivot",
                          label = "Pivot estimates/variables",
                          choices = c("none", "estimates", "estimates and variables"),
                          selected = "none"
                        ),
                        position = "right"
                      ),
                      DT::dataTableOutput("summarise_cohort_count_tidy")
                    )
                  )
                ),
                bslib::nav_panel(
                  title = "Table cohort count",
                  bslib::card(
                    full_screen = TRUE,
                    bslib::card_header(
                      bslib::popover(
                        shiny::icon("download"),
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_count_gt_9_download_type",
                          label = "File type",
                          selected = "docx",
                          choices = c("docx", "png", "pdf", "html"),
                          multiple = FALSE
                        ),
                        shiny::downloadButton(outputId = "summarise_cohort_count_gt_9_download", label = "Download")
                      ),
                      class = "text-end"
                    ),
                    bslib::layout_sidebar(
                      sidebar = bslib::sidebar(
                        sortable::bucket_list(
                          header = NULL,
                          sortable::add_rank_list(
                            text = "none",
                            labels = c("cdm_name", "variable_name", "estimate_name"),
                            input_id = "summarise_cohort_count_gt_9_none"
                          ),
                          sortable::add_rank_list(
                            text = "header",
                            labels = "cohort_name",
                            input_id = "summarise_cohort_count_gt_9_header"
                          ),
                          sortable::add_rank_list(
                            text = "groupColumn",
                            labels = NULL,
                            input_id = "summarise_cohort_count_gt_9_groupColumn"
                          ),
                          sortable::add_rank_list(
                            text = "hide",
                            labels = "variable_level",
                            input_id = "summarise_cohort_count_gt_9_hide"
                          )
                        ),
                        position = "right"
                      ),
                      gt::gt_output("summarise_cohort_count_gt_9")
                    )
                  )
                ),
                bslib::nav_panel(
                  title = "Plot cohort count",
                  bslib::card(
                    full_screen = TRUE,
                    bslib::card_header(
                      bslib::popover(
                        shiny::icon("download"),
                        shiny::numericInput(
                          inputId = "summarise_cohort_count_ggplot2_10_download_width",
                          label = "Width",
                          value = 15
                        ),
                        shiny::numericInput(
                          inputId = "summarise_cohort_count_ggplot2_10_download_height",
                          label = "Height",
                          value = 10
                        ),
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_count_ggplot2_10_download_units",
                          label = "Units",
                          selected = "cm",
                          choices = c("px", "cm", "inch"),
                          multiple = FALSE
                        ),
                        shiny::numericInput(
                          inputId = "summarise_cohort_count_ggplot2_10_download_dpi",
                          label = "dpi",
                          value = 300
                        ),
                        shiny::downloadButton(outputId = "summarise_cohort_count_ggplot2_10_download", label = "Download")
                      ),
                      class = "text-end"
                    ),
                    bslib::layout_sidebar(
                      sidebar = bslib::sidebar(
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_count_ggplot2_10_facet",
                          label = "facet",
                          selected = "cdm_name",
                          multiple = TRUE,
                          choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name"),
                          options = list(plugins = "remove_button")
                        ),
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_count_ggplot2_10_colour",
                          label = "colour",
                          selected = NULL,
                          multiple = TRUE,
                          choices = c("cdm_name", "cohort_name", "variable_name", "variable_level", "estimate_name"),
                          options = list(plugins = "remove_button")
                        ),
                        position = "right"
                      ),
                      shiny::plotOutput("summarise_cohort_count_ggplot2_10")
                    )
                  )
                )
              )
            )
          ),
          bslib::nav_panel(
            title = "Attrition",
            icon = shiny::icon("layer-group"),
            bslib::layout_sidebar(
              sidebar = bslib::sidebar(
                bslib::accordion(
                  bslib::accordion_panel(
                    title = "Information",
                    icon = shiny::icon("info"),
                    shiny::p("")
                  ),
                  bslib::accordion_panel(
                    title = "Settings",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_settings_cohort_definition_id",
                      label = "Cohort definition id",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    ),
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_settings_table_name",
                      label = "Table name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  ),
                  bslib::accordion_panel(
                    title = "grouping",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_grouping_cdm_name",
                      label = "Cdm name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    ),
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_grouping_cohort_name",
                      label = "Cohort name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    ),
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_grouping_reason",
                      label = "Reason",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    ),
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_grouping_reason_id",
                      label = "Reason id",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  ),
                  bslib::accordion_panel(
                    title = "Variables",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_variable_name",
                      label = "Variable name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  ),
                  bslib::accordion_panel(
                    title = "Estimates",
                    shiny::selectizeInput(
                      inputId = "summarise_cohort_attrition_estimate_name",
                      label = "Estimate name",
                      choices = NULL,
                      selected = NULL,
                      multiple = TRUE,
                      options = list(plugins = "remove_button")
                    )
                  )
                )
              ),
              bslib::navset_card_tab(
                bslib::nav_panel(
                  title = "Tidy",
                  bslib::card(
                    full_screen = TRUE,
                    bslib::card_header(
                      bslib::popover(
                        shiny::icon("download"),
                        shiny::downloadButton(outputId = "summarise_cohort_attrition_tidy_download", label = "Download csv")
                      ),
                      class = "text-end"
                    ),
                    bslib::layout_sidebar(
                      sidebar = bslib::sidebar(
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_attrition_tidy_columns",
                          label = "Columns",
                          choices = NULL,
                          selected = NULL,
                          multiple = TRUE,
                          options = list(plugins = "remove_button")
                        ),
                        shiny::radioButtons(
                          inputId = "summarise_cohort_attrition_tidy_pivot",
                          label = "Pivot estimates/variables",
                          choices = c("none", "estimates", "estimates and variables"),
                          selected = "none"
                        ),
                        position = "right"
                      ),
                      DT::dataTableOutput("summarise_cohort_attrition_tidy")
                    )
                  )
                ),
                bslib::nav_panel(
                  title = "Table cohort attrition",
                  bslib::card(
                    full_screen = TRUE,
                    bslib::card_header(
                      bslib::popover(
                        shiny::icon("download"),
                        shiny::selectizeInput(
                          inputId = "summarise_cohort_attrition_gt_3_download_type",
                          label = "File type",
                          selected = "docx",
                          choices = c("docx", "png", "pdf", "html"),
                          multiple = FALSE
                        ),
                        shiny::downloadButton(outputId = "summarise_cohort_attrition_gt_3_download", label = "Download")
                      ),
                      class = "text-end"
                    ),
                    bslib::layout_sidebar(
                      sidebar = bslib::sidebar(
                        sortable::bucket_list(
                          header = NULL,
                          sortable::add_rank_list(
                            text = "none",
                            labels = "reason",
                            input_id = "summarise_cohort_attrition_gt_3_none"
                          ),
                          sortable::add_rank_list(
                            text = "header",
                            labels = "variable_name",
                            input_id = "summarise_cohort_attrition_gt_3_header"
                          ),
                          sortable::add_rank_list(
                            text = "groupColumn",
                            labels = c("cdm_name", "cohort_name"),
                            input_id = "summarise_cohort_attrition_gt_3_groupColumn"
                          ),
                          sortable::add_rank_list(
                            text = "hide",
                            labels = c("variable_level", "reason_id", "estimate_name"),
                            input_id = "summarise_cohort_attrition_gt_3_hide"
                          )
                        ),
                        position = "right"
                      ),
                      gt::gt_output("summarise_cohort_attrition_gt_3")
                    )
                  )
                ),
                bslib::nav_panel(
                  title = "Diagram",
                  bslib::card(
                    full_screen = TRUE,
                    bslib::card_header(
                      bslib::popover(
                        shiny::icon("download"),
                        shiny::numericInput(
                          inputId = "summarise_cohort_attrition_grViz_4_download_width",
                          label = "Width (px)",
                          value = 15
                        ),
                        shiny::numericInput(
                          inputId = "summarise_cohort_attrition_grViz_4_download_height",
                          label = "Height (px)",
                          value = 10
                        ),
                        shiny::downloadButton(outputId = "summarise_cohort_attrition_grViz_4_download", label = "Download")
                      ),
                      class = "text-end"
                    ),
                    bslib::layout_sidebar(
                      sidebar = bslib::sidebar(,
                        position = "right"
                      ),
                      DiagrammeR::grVizOutput("summarise_cohort_attrition_grViz_4")
                    )
                  )
                )
              )
            )
          )
        ),
        bslib::nav_panel(
          title = "Overlap",
          icon = shiny::icon("circle-half-stroke"),
          bslib::layout_sidebar(
            sidebar = bslib::sidebar(
              bslib::accordion(
                bslib::accordion_panel(
                  title = "Information",
                  icon = shiny::icon("info"),
                  shiny::p("Cohort overlap shows the number of subjects that contribute to a pair of cohorts.")
                ),
                bslib::accordion_panel(
                  title = "grouping",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cdm_name",
                    label = "Cdm name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_reference",
                    label = "Cohort name reference",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  ),
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_grouping_cohort_name_comparator",
                    label = "Cohort name comparator",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Variables",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_variable_name",
                    label = "Variable name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                ),
                bslib::accordion_panel(
                  title = "Estimates",
                  shiny::selectizeInput(
                    inputId = "summarise_cohort_overlap_estimate_name",
                    label = "Estimate name",
                    choices = NULL,
                    selected = NULL,
                    multiple = TRUE,
                    options = list(plugins = "remove_button")
                  )
                )
              )
            ),
            bslib::navset_card_tab(
              bslib::nav_panel(
                title = "Tidy",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_tidy_download", label = "Download csv")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_tidy_columns",
                        label = "Columns",
                        choices = NULL,
                        selected = NULL,
                        multiple = TRUE,
                        options = list(plugins = "remove_button")
                      ),
                      shiny::radioButtons(
                        inputId = "summarise_cohort_overlap_tidy_pivot",
                        label = "Pivot estimates/variables",
                        choices = c("none", "estimates", "estimates and variables"),
                        selected = "none"
                      ),
                      position = "right"
                    ),
                    DT::dataTableOutput("summarise_cohort_overlap_tidy")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Table cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_gt_1_download_type",
                        label = "File type",
                        selected = "docx",
                        choices = c("docx", "png", "pdf", "html"),
                        multiple = FALSE
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_gt_1_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      sortable::bucket_list(
                        header = NULL,
                        sortable::add_rank_list(
                          text = "none",
                          labels = c("cohort_name_reference", "cohort_name_comparator", "estimate_name"),
                          input_id = "summarise_cohort_overlap_gt_1_none"
                        ),
                        sortable::add_rank_list(
                          text = "header",
                          labels = "variable_name",
                          input_id = "summarise_cohort_overlap_gt_1_header"
                        ),
                        sortable::add_rank_list(
                          text = "groupColumn",
                          labels = "cdm_name",
                          input_id = "summarise_cohort_overlap_gt_1_groupColumn"
                        ),
                        sortable::add_rank_list(
                          text = "hide",
                          labels = "variable_level",
                          input_id = "summarise_cohort_overlap_gt_1_hide"
                        )
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_gt_1_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    gt::gt_output("summarise_cohort_overlap_gt_1")
                  )
                )
              ),
              bslib::nav_panel(
                title = "Plot cohort overlap",
                bslib::card(
                  full_screen = TRUE,
                  bslib::card_header(
                    bslib::popover(
                      shiny::icon("download"),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_width",
                        label = "Width",
                        value = 15
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_height",
                        label = "Height",
                        value = 10
                      ),
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_units",
                        label = "Units",
                        selected = "cm",
                        choices = c("px", "cm", "inch"),
                        multiple = FALSE
                      ),
                      shiny::numericInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_download_dpi",
                        label = "dpi",
                        value = 300
                      ),
                      shiny::downloadButton(outputId = "summarise_cohort_overlap_ggplot2_2_download", label = "Download")
                    ),
                    class = "text-end"
                  ),
                  bslib::layout_sidebar(
                    sidebar = bslib::sidebar(
                      shiny::selectizeInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_facet",
                        label = "facet",
                        selected = c("cdm_name", "cohort_name_reference"),
                        multiple = TRUE,
                        choices = c("cdm_name", "cohort_name_reference", "cohort_name_comparator", "variable_name", "variable_level", "estimate_name"),
                        options = list(plugins = "remove_button")
                      ),
                      shiny::checkboxInput(
                        inputId = "summarise_cohort_overlap_ggplot2_2_uniqueCombinations",
                        label = "uniqueCombinations",
                        value = c(TRUE)
                      ),
                      position = "right"
                    ),
                    shiny::plotOutput("summarise_cohort_overlap_ggplot2_2")
                  )
                )
              )
            )
          )
        ),
        bslib::nav_spacer(),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("download"),
            shiny::downloadButton(
              outputId = "download_raw",
              label = "Download raw data",
              icon = shiny::icon("download")
            )
          )
        ),
        bslib::nav_item(
          bslib::popover(
            shiny::icon("circle-info"),
            shiny::tags$img(
              src = "hds_logo.svg",
              class = "logo-img",
              alt = "Logo",
              height = "auto",
              width = "30%",
              style = "float:right"
            ),
            "This shiny app was generated with ",
            shiny::a(
              "OmopViewer",
              href = "https://github.com/OHDSI/OmopViewer",
              target = "_blank"
            ),
            shiny::strong("v0.1.0")
          )
        ),
        bslib::nav_item(bslib::input_dark_mode(id = "dark_mode", mode = "light"))
      )

