% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OmicsPLS.R
\name{orth}
\alias{orth}
\title{Orthogonalize a matrix}
\usage{
orth(X, X_true = NULL, type = c("QR", "SVD"))
}
\arguments{
\item{X}{Numeric vector or matrix.}

\item{X_true}{(optional) A 'true' matrix/vector. Used to correct the sign of the orthonormalized X if QR is used. Only the first column is corrected.}

\item{type}{A character or numeric. Should be one of "QR" or "SVD".}
}
\value{
An orthogonalized representation of \eqn{X}
}
\description{
Orthogonalize a matrix
}
\details{
Choosing type='QR' uses a QR decomposition of X to produce orthonormal columns. For type=='SVD' it uses an SVD decomposition.
The columns are corrected for sign.
}
\examples{
orth(c(3,4))
round(crossprod(orth(matrix(rnorm(500),100,5))),4)
orth(matrix(1:9,3,3),type='QR')[,1] - orth(1:3); orth(matrix(1:9,3,3),type='SVD')[,1] - orth(1:3);
}
