% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addResultsLinkouts}
\alias{addResultsLinkouts}
\title{Add linkouts to external resources in the results table}
\usage{
addResultsLinkouts(study, resultsLinkouts, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{resultsLinkouts}{The URL patterns that describe linkouts to external
resources (see Details below). The input object is a nested named list. The
names of the list correspond to the model names. Each element of the list
is a named list of character vectors. The names of this nested list must
correspond to the column names of the matching features table. To share
linkouts across multiple models, use the modelID "default".}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
  \code{study}, but modified to include the newly added data
}
\description{
You can provide additional information on the features in your study by
providing linkouts to external resources. These will be embedded directly in
the results table.
}
\details{
For each linkout, the URL pattern you provide will be concatenated with the
value of that column for each row. As an example, if your features table
included a column named \code{"ensembl"} that contained the Ensembl Gene ID
for each feature, you could create a linkout to Ensembl using the following
pattern:

\preformatted{ensembl = "https://ensembl.org/Homo_sapiens/Gene/Summary?g="}

As another example, if you had a column named \code{"entrez"} that contained
the Entrez Gene ID  for each feature, you could create a linkout to Entrez
using the following pattern:

\preformatted{entrez = "https://www.ncbi.nlm.nih.gov/gene/"}

Note that you can provide more than one linkout per column.
}
\examples{
  study <- createStudy("example")
  resultsLinkouts <- list(
    default = list(
      ensembl = c("https://ensembl.org/Homo_sapiens/Gene/Summary?g=",
                  "https://www.genome.ucsc.edu/cgi-bin/hgGene?hgg_gene="),
      entrez = "https://www.ncbi.nlm.nih.gov/gene/"
    )
  )
  study <- addResultsLinkouts(study, resultsLinkouts)

}
\seealso{
\code{\link{addFeatures}}
}
