% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordination_plot.R
\name{ordination_plot}
\alias{ordination_plot}
\title{Ordination plot}
\usage{
ordination_plot(
  data,
  col_name,
  pair,
  dist_explained = NULL,
  dist_metric = NULL
)
}
\arguments{
\item{data}{A \link[base]{data.frame} or \link[data.table]{data.table} of Principal Components as columns and rows as loading scores.}

\item{col_name}{A categorical variable to color the contrasts (e.g. "groups").}

\item{pair}{A vector of character variables indicating what dimension names (e.g. PC1, NMDS2).}

\item{dist_explained}{A vector of numeric values of the percentage dissimilarity explained for the dimension pairs, default is NULL.}

\item{dist_metric}{A character variable indicating what metric is used (e.g. unifrac, bray-curtis), default is NULL.}
}
\value{
A \link[ggplot2]{ggplot2} object to be further modified
}
\description{
Creates an ordination plot pre-computed principal components from \link[vegan]{wcmdscale}.
This function is built into the class \link{omics} with method \code{ordination()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}.
}
\examples{
library(ggplot2)

# Mock principal component scores
set.seed(123)
mock_data <- data.frame(
  SampleID = paste0("Sample", 1:10),
  PC1 = rnorm(10, mean = 0, sd = 1),
  PC2 = rnorm(10, mean = 0, sd = 1),
  groups = rep(c("Group1", "Group2"), each = 5)
)

# Basic usage
ordination_plot(
  data = mock_data,
  col_name = "groups",
  pair = c("PC1", "PC2")
)

# Adding variance/dissimilarity explained.
ordination_plot(
  data = mock_data,
  col_name = "groups",
  pair = c("PC1", "PC2"),
  dist_explained = c(45, 22),
  dist_metric = "bray-curtis"
)
}
