% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Olink_wilcox.R
\name{olink_wilcox}
\alias{olink_wilcox}
\title{Function which performs a Mann-Whitney U Test per protein}
\usage{
olink_wilcox(df, variable, pair_id, ...)
}
\arguments{
\item{df}{NPX or Quantified_value data frame in long format with at least protein name (Assay), OlinkID, UniProt and a factor with 2 levels.}

\item{variable}{Character value indicating which column should be used as the grouping variable. Needs to have exactly 2 levels.}

\item{pair_id}{Character value indicating which column indicates the paired sample identifier.}

\item{...}{Options to be passed to wilcox.test. See \code{?wilcox_test} for more information.}
}
\value{
A data frame containing the Mann-Whitney U Test results for every protein.
}
\description{
Performs a Welch 2-sample Mann-Whitney U Test at confidence level 0.95 for every protein (by OlinkID)
for a given grouping variable using stats::wilcox.test and corrects for multiple testing by
the Benjamini-Hochberg method (“fdr”) using stats::p.adjust.
Adjusted p-values are logically evaluated towards adjusted p-value<0.05.
The resulting Mann-Whitney U Test table is arranged by ascending p-values.
}
\examples{
\donttest{

library(dplyr)

npx_df <- npx_data1 \%>\% filter(!grepl('control',SampleID, ignore.case = TRUE))

wilcox_results <- olink_wilcox(df = npx_df,
                               variable = 'Treatment',
                               alternative = 'two.sided')

#Paired Mann-Whitney U Test
npx_df \%>\%
   filter(Time \%in\% c("Baseline","Week.6")) \%>\%
   olink_wilcox(variable = "Time", pair_id = "Subject")
}
}
