% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{PMulti}
\alias{PMulti}
\title{A function to compute multigroup normalised exposure (PMulti)}
\usage{
PMulti(x)
}
\arguments{
\item{x}{- an object of class matrix (or which can be coerced to that class), 
where each column represents the distribution of a population group, within 
spatial units. The number of columns should be greater than 1 (at least 2 
population groups are required). You should not include a column with total 
population in each unit, because this will be interpreted as a group.}
}
\value{
Multigroup normalised isolation index
}
\description{
The multigroup normalised isolation index, PMulti, 
is a multigroup version of the isolation index (\code{\link{xPx}})
}
\examples{
x <- segdata@data[ ,1:2]
PMulti(x) 
}
\references{
James, F. J. (1986) \emph{A New Generalized 'Exposure-Based' 
Segregation Index}. Sociological Methods and Research, 14, pp. 301-316

Reardon S. F. and G. Firebaugh (2002) \emph{Measures of 
Multigroup Segregation}. Sociological Methodology, 32(1), pp 33-67
}
\seealso{
Multigroup indices: 
\code{\link{GiniMulti}}, \code{\link{DMulti}},  
\code{\link{HMulti}}, \code{\link{CMulti}}, \code{\link{RelDivers}}

Social diversity indices: 
\code{\link{HShannon}}, \code{\link{NShannon}}, 
\code{\link{ISimpson}},
}

