% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{Wong}
\alias{Wong}
\title{A function to compute Wong's segregation index}
\usage{
Wong(x, b = NULL, p = NULL, a = NULL,  spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}

\item{b}{- a common boundaries matrix where each element \emph{Bij}
equals the shared boundary of \emph{i}-th and \emph{j}-th spatial
units.}

\item{p}{- a vector with the perimeters of spatial units}

\item{a}{- a vector with areas of spatial units}

\item{spatobj}{- a spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A vector with Wong segregation index
}
\description{
Wong's segregation index develops \code{\link{Duncan}}'s
index by taking into account the interaction between spatial units
(common boundaries and perimeters). The function can be used
in two ways: by providing the boundaries matrix and perimeter
vector or a geographic source (spatial object or shape file) wich
will be used to compute the geographic information within the function
}
\examples{
x <- slot(AnnHAge, 'data')[ ,3:5]
bound <- boundaries(AnnHAge)
per <- perimeter(AnnHAge)
ar <- area(AnnHAge)
foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'AnnHAge'

Wong(x, b = bound, p = per, a = ar)

Wong(x, spatobj = AnnHAge)

Wong(x, folder = foldername, shape = shapename)
}
\references{
Wong D. W. S. (1998) \emph{Measuring multiethnic spatial
segregation}. Urban Geography, 19 (1), pp. 77-87.
}
\seealso{
Other evenness intragroup  indices: \code{\link{Duncan}},
\code{\link{Morill}}, \code{\link{Gini}}, \code{\link{Gorard}}

Intergroup dissimilarity index: \code{\link{DI}}
}

