\name{grab_group}
\alias{grab_group}

\title{
Subset OTU table by taxonomic assignment
}
\description{
Returns a table containing only taxa from a given phylogenetic group
}
\usage{
grab_group(group, level, table, taxonomy)
}
\arguments{
	\item{group}{
  The phylogenetic classification of interest (can be a regular expression)
}
	\item{level}{
  The phylogenetic level of the group of interest (must be a column name in the taxonomy file)
}
	\item{table}{
  A table containing the relative abundances of each OTU in the form produced by clean_shared()
}
	\item{taxonomy}{
  A taxonomy dataset in the form produced by expand_taxa()
}
}

\value{
Returns a table with all taxa of a given taxonomic assignment
}
\note{
This function must be run on the OTU level table. However, the output of this function can be run through combine_otus() to create a higher level table of results. Sometimes closely related groups were classified better in the Greengenes vs the freshwater database during classification of the NTL-Microbial Observatory dataset. In this case, it is necessary to search for the names generated by both datasets to get all closely related OTUs.
For example, Methylophilaceae in Greengenes are named betIV in the freshwater database.

}
\author{
Alexandra Linz <amlinz16@gmail.com>
}


\keyword{data_processing}

\examples{
 
data(otu_table)
data(taxonomy)

acI <- grab_group("acI", "Clade", otu_table, taxonomy)
verruco <- grab_group("Verrucomicrobia", "Phylum", otu_table, taxonomy)

# Example where two search terms are needed due to classification with two databases
methylophilaceae <- grab_group("Methylophilaceae|betIV", "Clade", otu_table, taxonomy)
}
