\name{bog_subset}
\alias{bog_subset}

\title{
Subset OTU table by sampling site
}
\description{
Returns an OTU table containing only samples from the identified sampling site. This function can also be used on tables of higher level taxa generated by combine_otus(), or on tables that have already been processed by year_subset().
}
\usage{
bog_subset(bog_id, table)
}
\arguments{
	\item{bog_id}{
  The three letter code indicating the sampling site. The bog is represented by letters one and two; options are TB, SS, CB, NS, MA, HK, WS, and FB. The third letter indicates the layer; E for epilimnion and H for hypolimnion. The bog_id should be in quotes, and regular expressions can be used.
  }
	\item{table}{
  A table containing the relative abundances of each taxon as rows and samples as columns. Sample names must be coded in the format bog, layer, date, and replicate (example: TBE07JUN08.R2 == Trout Bog Epilimnion, collected 07Jun08, replicate 2)
  }
}


\value{
Returns a relative abundance table containing samples from the specified sampling site in columns, with taxa in rows
}

\author{
Alexandra Linz <amlinz16@gmail.com>
}

\keyword{ data_processing }

\examples{
data(otu_table)

Trout_Bog_Epilimnion <- bog_subset("TBE", otu_table)

Hells_Kitchen_Hypolimnion <- bog_subset("HKH", otu_table)

# Include both epilimnion and hypolimnion in a single table
Trout_Bog_both_layers <- bog_subset("TB.", otu_table)

# Include all meromictic hypolimnia
meromictic_hypolimnia <- bog_subset("HKH|MAH", otu_table)

}
