% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opi.r
\name{chooseOpi}
\alias{chooseOpi}
\alias{chooseOPI}
\title{Choose an implementation of the OPI}
\usage{
chooseOpi(opiImplementation)

chooseOPI(opiImplementation)
}
\arguments{
\item{opiImplementation}{A character string that is one of the following.
\itemize{
\item \code{"SimNo"} for a simulator that always doesn't see.
\item \code{"SimYes"} for a simulator that always does see.
\item \code{"SimHenson"} for a simulator that uses a cummulative gaussian psychometric function with standard deviation according to Henson et al (2000) where variability increases as true threshold (Humphrey dB) value decreases.
\item \code{"SimHensonRT"} as for SimHenson, but response times in ms are sampled from a supplied response time data set for each true positive response.
\item \code{"SimGaussian"} for a simulator that uses a cummulative gaussian psychometric function with standard deviation supplied in opiInitialize().
\item \code{"Octopus900"} for interfacing with the Octopus 900.
\item \code{"Octopus900F310"} for interfacing with the Octopus 900 using Logitech F310 controller.
\item \code{"Octopus600"} for interfacing with the Octopus 600.
\item \code{"HEP"}        not working so well in HEPs.
\item \code{"KowaAP7000"} for interfacing with Kowa AP-7000.
\item \code{"Imo"} for interfacing with CrewT's Imo head mounted perimeter.
\item \code{"DayDream"} for interfacing with an Android phone in a Google Daydream
\item \code{"Display"} for interfacing with a shiny plot area on the current machine.
\item \code{"PhoneHMD"} for interfacing with phones using VR. At the moment, only Android compatible phones are working. The VR headset must be compatible with Cardboard
\item \code{NULL}         print a list of available OPI implementations.
}}
}
\value{
Returns TRUE if successful, FALSE otherwise.
}
\description{
Chooses an implementation of the OPI to use
}
\examples{
if(!chooseOpi("SimHenson"))
  warnings()
}
\references{
David B. Henson, Shaila Chaudry, Paul H. Artes, E. Brian Faragher, and Alec Ansons.
Response Variability in the Visual Field: Comparison of Optic Neuritis, Glaucoma,
Ocular Hypertension, and Normal Eyes. Investigative Ophthalmology & Visual Science,
February 2000, Vol. 41(2).

A.M. McKendrick, J. Denniss and A. Turpin. "Response times across the visual field:
empirical observations and application to threshold determination". Vision Research,
101, 2014.

A. Turpin, P.H. Artes and A.M. McKendrick. "The Open Perimetry Interface: An
enabling tool for clinical visual psychophysics", Journal of Vision 12(11) 2012.
}
