% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{kpe}
\alias{kpe}
\title{determine factor number - projected}
\usage{
kpe(Y, kmax = 4, c = 0)
}
\arguments{
\item{Y}{data, a \eqn{T\times p1\times p2} array.}

\item{kmax}{a positive integer smaller than p2, indicating the
upper bound for the factor numbers, and the dimension of projection matrix.}

\item{c}{a non-negative but small number, to ensure the
denominator of the eigenvalue ratio statistics is not 0.}
}
\value{
a 2-dimensional vector containing the estimated
number of row and column factors, respectively.
}
\description{
This function determined the numbers of row and column factors
for matrix variate data under a two-way factor model, using a projected method.
}
\examples{
k1=3
k2=3
Sample_T=100
p1=40
p2=20
kmax=8

Y=gen.data(Sample_T,p1,p2,k1,k2,tau=0.5,change=0)
kpe(Y,kmax)


}
\references{
Yu L, He Y, Kong X, & Zhang X (2022). Projected estimation for
 large-dimensional matrix factor models. \emph{Journal of Econometrics},
 229(1),201-217.
}
