% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ODT.R
\name{predict.ODT}
\alias{predict.ODT}
\title{making predict based on ODT objects}
\usage{
\method{predict}{ODT}(object, Xnew, leafnode = FALSE, ...)
}
\arguments{
\item{object}{An object of class ODT, the same as that created by the function \code{\link{ODT}}.}

\item{Xnew}{An n by d numeric matrix (preferable) or data frame. The rows correspond to observations and columns correspond to features.
Note that if there are NA values in the data 'Xnew', which will be replaced with the average value.}

\item{leafnode}{If or not output the leaf node sequence number that \code{Xnew} is partitioned. (default FALSE)}

\item{...}{Arguments to be passed to methods.}
}
\value{
A vector of the following:
\itemize{
\item prediction: the prediced response of the new data.
\item leafnode: the leaf node sequence number that the new data is partitioned.
}
}
\description{
Prediction of ODT for an input matrix or data frame.
}
\examples{
# Classification with Oblique Decision Tree.
data(seeds)
set.seed(221212)
train <- sample(1:209, 100)
train_data <- data.frame(seeds[train, ])
test_data <- data.frame(seeds[-train, ])

tree <- ODT(varieties_of_wheat ~ ., train_data, split = "entropy")
pred <- predict(tree, test_data[, -8])
# classification error
(mean(pred != test_data[, 8]))

# Regression with Oblique Decision Tree.
data(body_fat)
set.seed(221212)
train <- sample(1:252, 100)
train_data <- data.frame(body_fat[train, ])
test_data <- data.frame(body_fat[-train, ])

tree <- ODT(Density ~ ., train_data, split = "mse")
pred <- predict(tree, test_data[, -1])
# estimation error
mean((pred - test_data[, 1])^2)

}
\references{
Zhan, H., Liu, Y., & Xia, Y. (2022). Consistency of The Oblique Decision Tree and Its Random Forest. arXiv preprint arXiv:2211.12653.
}
\seealso{
\code{\link{ODT}} \code{\link{predict.ODRF}}
}
\keyword{predict}
\keyword{tree}
