% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{sc_weights}
\alias{sc_weights}
\title{Calculates Schonlau and Couper weights}
\usage{
sc_weights(propensities)
}
\arguments{
\item{propensities}{A vector with the propensities associated to the elements of the convenience sample.}
}
\value{
A vector with the corresponding weights.
}
\description{
Computes weights from propensity estimates using the (1 - p_i)/pi_i formula introduced in Schonlau and Couper (2017).
}
\details{
The function takes the vector of propensities \eqn{\pi(x)} and calculates the weights to be applied in the Hajek estimator using the formula that can be found in Schonlau and Couper (2017). For an individual \emph{i}, weight is calculated as follows:
\deqn{w_i = \frac{1 - \pi_i (x)}{\pi_i (x)}}
}
\examples{
covariates = c("education_primaria", "education_secundaria", "education_terciaria")
data_propensities = propensities(sampleNP, sampleP, covariates)
sc_weights(data_propensities$convenience)
}
\references{
Schonlau, M., & Couper, M. P. (2017). \emph{Options for conducting web surveys.} Statistical Science, 32(2), 279-292.
}
