% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{calib_weights}
\alias{calib_weights}
\title{Weights of the calibration estimator}
\usage{
calib_weights(Xs, totals, initial_weights, N, ...)
}
\arguments{
\item{Xs}{Matrix of calibration variables.}

\item{totals}{A vector containing population totals for each column (class) of the calibration variables matrix.}

\item{initial_weights}{A vector containing the initial weights for each individual.}

\item{N}{Integer indicating the population size.}

\item{...}{Further arguments to be passed to the `calib` function from the `sampling` package.}
}
\value{
A vector with the corresponding weights.
}
\description{
Calculates the calibration weights from a disjunct matrix of covariates, a vector of population totals and a vector of initial weights.
}
\details{
The function uses the `calib` function from the `sampling` package for the estimation of g-weights, which are multiplied by the initial weights to obtain the final calibration weights. The initial weights can be calculated previously from the propensities for any of the implemented methods (see functions \code{lee_weights}, \code{sc_weights}, \code{valliant_weights}, \code{vd_weights}). The population size is used to scale said initial weights so they are easier to calibrate.
}
\examples{
n = nrow(sampleNP)
N = 50000
language_total = 45429
covariates = c("education_primaria","education_secundaria","education_terciaria","age","sex")
pi = propensities(sampleNP, sampleP, covariates, algorithm = "glm", smooth = FALSE)
wi = sc_weights(pi$convenience)
calib_weights(sampleNP$language, language_total, wi, N, method = "raking")
}
