% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{gm_expected_patterns_tbl_df}
\alias{gm_expected_patterns_tbl_df}
\title{Patterns of Gray Matter in Schizophrenia}
\format{
A tibble with 33 observations and 16 variables:
\describe{
  \item{GM}{Character vector indicating gray matter regions}
  \item{SSD}{Numeric vector of expected patterns for schizophrenia spectrum disorder}
  \item{MDD}{Numeric vector of expected patterns for major depressive disorder}
  \item{AD_ADNI}{Numeric vector of expected patterns for Alzheimer's disease (ADNI cohort)}
  \item{AD_ADNIOSYRIX}{Numeric vector of expected patterns for Alzheimer's disease (ADNI+OSYRIX cohort)}
  \item{BD}{Numeric vector of expected patterns for bipolar disorder}
  \item{PD}{Numeric vector of expected patterns for Parkinson's disease}
  \item{Diabetes}{Numeric vector of expected patterns for diabetes}
  \item{HighBP}{Numeric vector of expected patterns for high blood pressure}
  \item{HighLipids}{Numeric vector of expected patterns for high lipids}
  \item{MET}{Numeric vector of expected patterns for metabolic syndrome}
  \item{DS_22q}{Numeric vector of expected patterns for 22q11.2 deletion syndrome}
  \item{Suicide}{Numeric vector of expected patterns for suicide}
  \item{OCD_pediatric}{Numeric vector of expected patterns for pediatric OCD}
  \item{OCD_adult}{Numeric vector of expected patterns for adult OCD}
  \item{AN}{Numeric vector of expected patterns for anorexia nervosa}
}
}
\source{
Data taken from the RVIpkg package version 0.3.2.
}
\usage{
data(gm_expected_patterns_tbl_df)
}
\description{
This dataset, gm_expected_patterns_tbl_df, is a tibble containing expected patterns
of gray matter in schizophrenia derived from large-scale meta-analyses by the ENIGMA consortium.
It includes data from multiple neurological and psychiatric conditions for comparison.
}
\details{
The dataset name has been kept as 'gm_expected_patterns_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
NeuroDataSets package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble. The original content has not been modified
in any way.
}
