% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActFunc.R
\name{DerActFunc}
\alias{DerActFunc}
\title{Derivative of activation function of neuron}
\usage{
DerActFunc(type = "sigmoid", ...)
}
\arguments{
\item{type}{\code{character} name of the activation function}

\item{...}{extra arguments needed to calculate the functions}
}
\value{
\code{numeric} output of the neuron
}
\description{
Evaluate derivative of activation function of a neuron
}
\examples{
# Return derivative of the sigmoid activation function of a neuron
ActivationFunction <- DerActFunc("sigmoid")
# Return derivative of the tanh activation function of a neuron
ActivationFunction <- DerActFunc("tanh")
# Return derivative of the activation function of several layers of neurons
actfuncs <- c("linear","sigmoid","linear")
ActivationFunctions <- sapply(actfuncs, DerActFunc)
}
\references{
Pizarroso J, Portela J, Muñoz A (2022). NeuralSens: Sensitivity Analysis of
Neural Networks. Journal of Statistical Software, 102(7), 1-36.
}
