% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.permutation.R
\name{network.permutation}
\alias{network.permutation}
\title{Permutation Test for Network Measures}
\usage{
network.permutation(
  sample1 = NULL,
  sample2 = NULL,
  iter,
  network = c("glasso", "ising", "TMFG", "LoGo"),
  measure = c("betweenness", "closeness", "strength", "rspbc", "hybrid", "ASPL", "CC",
    "S", "Q"),
  alternative = c("less", "greater", "two.tailed"),
  ncores,
  prev.perm = NULL
)
}
\arguments{
\item{sample1}{Matrix or data frame.
Sample to be compared with \code{sample2}}

\item{sample2}{Matrix or data frame.
Sample to be compared with \code{sample1}}

\item{iter}{Numeric.
Number of iterations to perform.
Defaults to \code{1000}}

\item{network}{Character.
Network estimation method to apply to the datasets.
Defaults to \code{"glasso"}}

\item{measure}{Character.
Network measure to be compared in the permutation test}

\item{alternative}{Character.
Alternative hypothesis test to perform.
Defaults to \code{"two.tailed"}}

\item{ncores}{Numeric.
Number of computer processing cores to use for bootstrapping samples.
Defaults to \emph{n} - 1 total number of cores.
Set to any number between 1 and maximum amount of cores on your computer
(see \code{parellel::detectCores()})}

\item{prev.perm}{\code{network.permutation} class object.
An object of previously performed permutation test. The
networks generated in the previous permutation will be
used to compute other network measures. This saves time
when computing multiple permutation tests}
}
\value{
Returns a list containing two objects:

\item{result}{The results of the permutation test. For centrality measures,
this is a matrix where the rows represent each node and the columns are
the observed values of the centrality measure for \code{sample1}, \code{sample2},
and the \emph{p}-value from the permutation test. For global network measures,
this is a vector with the observed values of the global network measure for
\code{sample1}, \code{sample2}, and the \emph{p}-value from the permutation test.}

\item{networks}{A list containing two lists: \code{network1} and \code{network2}.
The network lists correspond to the networks generated in the permutation test
for \code{sample1} and \code{sample2}, respectively. This output is used primarily
for the computation of other network measures using the same datasets
(see \code{prev.perm} explanation)}
}
\description{
Computes a permutation test to determine whether
there are difference in centrality and global network measures
}
\examples{
# Split data (only for example)
split1 <- neoOpen[c(1:401),]
split2 <- neoOpen[c(402:802),]

\donttest{
# Perform permutation test
perm.str <- network.permutation(split1, split2, iter = 1000, network = "glasso",
measure = "strength", alternative = "two.tailed", ncores = 2)

# Check results
perm.str$result

# Permutation to check other measures (using networks from previous result)
perm.aspl <- network.permutation(prev.perm = perm.str, measure = "ASPL", ncores = 2)

# Check results
perm.aspl$result

}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
