% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NetworkToolbox--master.R
\name{semnetmeas}
\alias{semnetmeas}
\title{Semantic Network Measures}
\usage{
semnetmeas(A, iter)
}
\arguments{
\item{A}{An adjacency matrix of network A}

\item{iter}{Number of iterations for the small-worldness measure}
}
\value{
Returns a values for ASPL, CC, Q, and S
}
\description{
Computes the average shortest path length (ASPL),
clustering coefficient(CC),
modularity (Q),
and small-worldness (S; defaults to "rand")
}
\examples{
\dontrun{
lowO <- subset(animals, Group==1)[-1]

A<-PMFG(lowO)

globmeas<-semnetmeas(A)
}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
